/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import org.eclipse.transformer.action.BundleData;

public class BundleDataImpl
implements BundleData {
    private final String symbolicName;
    private final String version;
    private final boolean addName;
    private final String name;
    private final boolean addDescription;
    private final String description;

    public BundleDataImpl(String symbolicName, String version, boolean addName, String name, boolean addDescription, String description) {
        this.symbolicName = symbolicName;
        this.version = version;
        this.addName = addName;
        this.name = name;
        this.addDescription = addDescription;
        this.description = description;
    }

    public BundleDataImpl(String packedData) throws IllegalArgumentException {
        String[] heads = new String[3];
        String tail = packedData;
        for (int commaNo = 0; commaNo < 3; ++commaNo) {
            int comma = tail.indexOf(44);
            String head = null;
            String nextTail = null;
            if (comma != -1) {
                head = tail.substring(0, comma).trim();
                nextTail = tail.substring(comma + 1).trim();
            }
            if (head == null || nextTail == null || nextTail.isEmpty()) {
                throw BundleDataImpl.formatError(packedData);
            }
            heads[commaNo] = head;
            tail = nextTail;
        }
        this.symbolicName = heads[0];
        this.version = heads[1];
        String useName = heads[2];
        String useDescription = tail;
        boolean bl = this.addName = useName.charAt(0) == '+';
        if (this.addName) {
            useName = useName.substring(1).trim();
        }
        if ((useName = BundleDataImpl.unquote(useName)) == null) {
            throw BundleDataImpl.formatError(packedData);
        }
        this.name = useName;
        boolean bl2 = this.addDescription = useDescription.charAt(0) == '+';
        if (this.addDescription) {
            useDescription = useDescription.substring(1).trim();
        }
        if ((useDescription = BundleDataImpl.unquote(useDescription)) == null) {
            throw BundleDataImpl.formatError(packedData);
        }
        this.description = useDescription;
    }

    private static IllegalArgumentException formatError(String text) {
        return new IllegalArgumentException("Incorrectly formatted bundle identity update [ " + text + " ]");
    }

    private static String unquote(String text) {
        if (text.isEmpty()) {
            return null;
        }
        if (text.charAt(0) != '\"') {
            return text;
        }
        int textLen = text.length();
        if (textLen < 2) {
            return null;
        }
        if (text.charAt(textLen - 1) != '\"') {
            return null;
        }
        return text.substring(1, textLen - 1);
    }

    @Override
    public String getPrintString() {
        String useName = this.addName ? '+' + this.name : this.name;
        String useDescription = this.addDescription ? '+' + this.description : this.description;
        return "Bundle data [ " + this.symbolicName + " ] version [ " + this.version + " ] name [ " + useName + " ] description [ " + useDescription + " ]";
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean getAddName() {
        return this.addName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getAddDescription() {
        return this.addDescription;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String updateName(String initialName) {
        String nameUpdate = this.getName();
        return this.getAddName() ? initialName + nameUpdate : nameUpdate;
    }

    @Override
    public String updateDescription(String initialDescription) {
        String descriptionUpdate = this.getDescription();
        return this.getAddDescription() ? initialDescription + descriptionUpdate : descriptionUpdate;
    }
}

