/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.helpers.DatamodelMapper;
import org.wikidata.wdtk.datamodel.implementation.EntityDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.ItemDocumentImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.WbGetEntitiesActionData;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class WbGetEntitiesAction {
    static final Logger logger = LoggerFactory.getLogger(WbGetEntitiesAction.class);
    final ApiConnection connection;
    final String siteIri;
    final ObjectMapper mapper;

    public WbGetEntitiesAction(ApiConnection connection, String siteIri) {
        this.connection = connection;
        this.siteIri = siteIri;
        this.mapper = new DatamodelMapper(siteIri);
    }

    public Map<String, EntityDocument> wbGetEntities(WbGetEntitiesActionData properties) throws MediaWikiApiErrorException, IOException {
        return this.wbGetEntities(properties.ids, properties.sites, properties.titles, properties.props, properties.languages, properties.sitefilter);
    }

    public Map<String, EntityDocument> wbGetEntities(String ids, String sites, String titles, String props, String languages, String sitefilter) throws MediaWikiApiErrorException, IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("action", "wbgetentities");
        if (ids != null) {
            parameters.put("ids", ids);
            if (titles != null || sites != null) {
                throw new IllegalArgumentException("Cannot use parameters \"sites\" or \"titles\" when using ids to get entity data");
            }
        } else if (titles != null) {
            parameters.put("titles", titles);
            if (sites == null) {
                throw new IllegalArgumentException("Sites parameter is required when using titles parameter to get entity data.");
            }
            parameters.put("sites", sites);
        } else {
            throw new IllegalArgumentException("Either ids, or titles and site must be specified for this action.");
        }
        if (props != null) {
            parameters.put("props", props);
        }
        if (languages != null) {
            parameters.put("languages", languages);
        }
        if (sitefilter != null) {
            parameters.put("sitefilter", sitefilter);
        }
        HashMap<String, EntityDocument> result = new HashMap<String, EntityDocument>();
        try {
            JsonNode root = this.connection.sendJsonRequest("POST", parameters);
            JsonNode entities = root.path("entities");
            Iterator entitiesIterator = entities.fields();
            while (entitiesIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)entitiesIterator.next();
                JsonNode entityNode = (JsonNode)entry.getValue();
                if (entityNode.has("missing")) continue;
                try {
                    EntityDocument ed = (EntityDocument)this.mapper.treeToValue((TreeNode)entityNode, EntityDocumentImpl.class);
                    if (titles == null) {
                        result.put((String)entry.getKey(), ed);
                        continue;
                    }
                    if (!(ed instanceof ItemDocumentImpl) || !((ItemDocumentImpl)ed).getSiteLinks().containsKey(sites)) continue;
                    result.put(((SiteLink)((ItemDocumentImpl)ed).getSiteLinks().get(sites)).getPageTitle(), ed);
                }
                catch (JsonProcessingException e) {
                    logger.error("Error when reading JSON for entity " + entityNode.path("id").asText("UNKNOWN") + ": " + e.toString());
                }
            }
        }
        catch (IOException e) {
            logger.error("Could not retrive data: " + e.toString());
            throw e;
        }
        return result;
    }
}

