/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.helpers.DatamodelMapper;
import org.wikidata.wdtk.datamodel.implementation.EntityDocumentImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.apierrors.MaxlagErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.TokenErrorException;

public class WbEditingAction {
    static final Logger logger = LoggerFactory.getLogger(WbEditingAction.class);
    static int MAXLAG_SLEEP_TIME = 5000;
    final ApiConnection connection;
    final String siteIri;
    final ObjectMapper mapper;
    String csrfToken = null;
    int maxLag = 5;
    static final int editTimeWindow = 9;
    int averageMsecsPerEdit = 2000;
    final long[] recentEditTimes = new long[9];
    int curEditTimeSlot = 0;
    int remainingEdits = -1;

    public WbEditingAction(ApiConnection connection, String siteIri) {
        this.connection = connection;
        this.siteIri = siteIri;
        this.mapper = new DatamodelMapper(siteIri);
    }

    public int getMaxLag() {
        return this.maxLag;
    }

    public void setMaxLag(int maxLag) {
        this.maxLag = maxLag;
    }

    public int getRemainingEdits() {
        return this.remainingEdits;
    }

    public void setRemainingEdits(int remainingEdits) {
        this.remainingEdits = remainingEdits;
    }

    public int getAverageTimePerEdit() {
        return this.averageMsecsPerEdit;
    }

    public void setAverageTimePerEdit(int milliseconds) {
        this.averageMsecsPerEdit = milliseconds;
    }

    public EntityDocument wbEditEntity(String id, String site, String title, String newEntity, String data, boolean clear, boolean bot, long baserevid, String summary) throws IOException, MediaWikiApiErrorException {
        Validate.notNull((Object)data, (String)"Data parameter cannot be null when editing entity data", (Object[])new Object[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("data", data);
        if (clear) {
            parameters.put("clear", "");
        }
        JsonNode response = this.performAPIAction("wbeditentity", id, site, title, newEntity, parameters, summary, baserevid, bot);
        return this.getEntityDocumentFromResponse(response);
    }

    public JsonNode wbSetLabel(String id, String site, String title, String newEntity, String language, String value, boolean bot, long baserevid, String summary) throws IOException, MediaWikiApiErrorException {
        Validate.notNull((Object)language, (String)"Language parameter cannot be null when setting a label", (Object[])new Object[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("language", language);
        if (value != null) {
            parameters.put("value", value);
        }
        JsonNode response = this.performAPIAction("wbsetlabel", id, site, title, newEntity, parameters, summary, baserevid, bot);
        return response;
    }

    public JsonNode wbSetDescription(String id, String site, String title, String newEntity, String language, String value, boolean bot, long baserevid, String summary) throws IOException, MediaWikiApiErrorException {
        Validate.notNull((Object)language, (String)"Language parameter cannot be null when setting a description", (Object[])new Object[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("language", language);
        if (value != null) {
            parameters.put("value", value);
        }
        JsonNode response = this.performAPIAction("wbsetdescription", id, site, title, newEntity, parameters, summary, baserevid, bot);
        return response;
    }

    public JsonNode wbSetAliases(String id, String site, String title, String newEntity, String language, List<String> add, List<String> remove, List<String> set, boolean bot, long baserevid, String summary) throws IOException, MediaWikiApiErrorException {
        Validate.notNull((Object)language, (String)"Language parameter cannot be null when setting aliases", (Object[])new Object[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("language", language);
        if (set != null) {
            if (add != null || remove != null) {
                throw new IllegalArgumentException("Cannot use parameters \"add\" or \"remove\" when using \"set\" to edit aliases");
            }
            parameters.put("set", ApiConnection.implodeObjects(set));
        }
        if (add != null) {
            parameters.put("add", ApiConnection.implodeObjects(add));
        }
        if (remove != null) {
            parameters.put("remove", ApiConnection.implodeObjects(remove));
        }
        JsonNode response = this.performAPIAction("wbsetaliases", id, site, title, newEntity, parameters, summary, baserevid, bot);
        return response;
    }

    public JsonNode wbSetClaim(String statement, boolean bot, long baserevid, String summary) throws IOException, MediaWikiApiErrorException {
        Validate.notNull((Object)statement, (String)"Statement parameter cannot be null when adding or changing a statement", (Object[])new Object[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("claim", statement);
        return this.performAPIAction("wbsetclaim", null, null, null, null, parameters, summary, baserevid, bot);
    }

    public JsonNode wbRemoveClaims(List<String> statementIds, boolean bot, long baserevid, String summary) throws IOException, MediaWikiApiErrorException {
        Validate.notNull(statementIds, (String)"statementIds parameter cannot be null when deleting statements", (Object[])new Object[0]);
        Validate.notEmpty(statementIds, (String)"statement ids to delete must be non-empty when deleting statements", (Object[])new Object[0]);
        Validate.isTrue((statementIds.size() <= 50 ? 1 : 0) != 0, (String)"At most 50 statements can be deleted at once", (Object[])new Object[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("claim", String.join((CharSequence)"|", statementIds));
        return this.performAPIAction("wbremoveclaims", null, null, null, null, parameters, summary, baserevid, bot);
    }

    private JsonNode performAPIAction(String action, String id, String site, String title, String newEntity, Map<String, String> parameters, String summary, long baserevid, boolean bot) throws IOException, MediaWikiApiErrorException {
        parameters.put("action", action);
        if (newEntity != null) {
            parameters.put("new", newEntity);
            if (title != null || site != null || id != null) {
                throw new IllegalArgumentException("Cannot use parameters \"id\", \"site\", or \"title\" when creating a new entity.");
            }
        } else if (id != null) {
            parameters.put("id", id);
            if (title != null || site != null) {
                throw new IllegalArgumentException("Cannot use parameters \"site\" or \"title\" when using id to edit entity data");
            }
        } else if (title != null) {
            if (site == null) {
                throw new IllegalArgumentException("Site parameter is required when using title parameter to edit entity data.");
            }
            parameters.put("site", site);
            parameters.put("title", title);
        } else if (!"wbsetclaim".equals(action) && !"wbremoveclaims".equals(action)) {
            throw new IllegalArgumentException("This action must create a new item, or specify an id, or specify a site and title.");
        }
        if (bot) {
            parameters.put("bot", "");
        }
        if (baserevid != 0L) {
            parameters.put("baserevid", Long.toString(baserevid));
        }
        if (summary != null) {
            parameters.put("summary", summary);
        }
        parameters.put("maxlag", Integer.toString(this.maxLag));
        parameters.put("token", this.getCsrfToken());
        if (this.remainingEdits > 0) {
            --this.remainingEdits;
        } else if (this.remainingEdits == 0) {
            logger.info("Not editing entity (simulation mode). Request parameters were: " + parameters.toString());
            return null;
        }
        this.checkEditSpeed();
        JsonNode result = null;
        MediaWikiApiErrorException lastException = null;
        for (int retry = 5; retry > 0; --retry) {
            try {
                result = this.connection.sendJsonRequest("POST", parameters);
                break;
            }
            catch (TokenErrorException e) {
                lastException = e;
                this.refreshCsrfToken();
                parameters.put("token", this.getCsrfToken());
                continue;
            }
            catch (MaxlagErrorException e) {
                lastException = e;
                logger.warn(e.getMessage() + " -- pausing for 5 seconds.");
                try {
                    Thread.sleep(MAXLAG_SLEEP_TIME);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (lastException != null) {
            logger.error("Gave up after several retries. Last error was: " + lastException.toString());
            throw lastException;
        }
        return result;
    }

    protected EntityDocument getEntityDocumentFromResponse(JsonNode root) throws IOException {
        if (root == null) {
            return null;
        }
        if (root.has("item")) {
            return this.parseJsonResponse(root.path("item"));
        }
        if (root.has("property")) {
            return this.parseJsonResponse(root.path("property"));
        }
        if (root.has("entity")) {
            return this.parseJsonResponse(root.path("entity"));
        }
        throw new JsonMappingException("No entity document found in API response.");
    }

    private EntityDocument parseJsonResponse(JsonNode entityNode) throws IOException {
        return (EntityDocument)this.mapper.readerFor(EntityDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT).readValue(entityNode);
    }

    private String getCsrfToken() {
        if (this.csrfToken == null) {
            this.refreshCsrfToken();
        }
        return this.csrfToken;
    }

    private void refreshCsrfToken() {
        this.csrfToken = this.fetchCsrfToken();
    }

    private String fetchCsrfToken() {
        try {
            return this.connection.fetchToken("csrf");
        }
        catch (IOException | MediaWikiApiErrorException e) {
            logger.error("Error when trying to fetch csrf token: " + e.toString());
            return null;
        }
    }

    private void checkEditSpeed() {
        long currentTime = System.nanoTime();
        int nextIndex = (this.curEditTimeSlot + 1) % 9;
        if (this.recentEditTimes[nextIndex] != 0L && (currentTime - this.recentEditTimes[nextIndex]) / 1000000L < (long)(this.averageMsecsPerEdit * 9)) {
            long sleepTime = (long)(this.averageMsecsPerEdit * 9) - (currentTime - this.recentEditTimes[nextIndex]) / 1000000L;
            logger.info("We are editing too fast. Pausing for " + sleepTime + " milliseconds.");
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            currentTime = System.nanoTime();
        }
        this.recentEditTimes[nextIndex] = currentTime;
        this.curEditTimeSlot = nextIndex;
    }
}

