/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.select2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.string.StringValue;
import org.wicketstuff.select2.AbstractSelect2Choice;
import org.wicketstuff.select2.ChoiceProvider;

public class Select2MultiChoice<T>
extends AbstractSelect2Choice<T, Collection<T>> {
    private static final long serialVersionUID = 1L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String EMPTY_STRING = "";

    public Select2MultiChoice(String id) {
        super(id);
    }

    public Select2MultiChoice(String id, IModel<Collection<T>> model) {
        super(id, model);
    }

    public Select2MultiChoice(String id, IModel<Collection<T>> model, ChoiceProvider<T> provider) {
        super(id, model, provider);
    }

    public Select2MultiChoice(String id, ChoiceProvider<T> provider) {
        super(id, provider);
    }

    public final String[] getInputAsArray() {
        List value = this.getRequest().getRequestParameters().getParameterValues(this.getInputName());
        if (value == null || value.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (StringValue v : value) {
            if (v.isEmpty()) continue;
            result.add(v.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public void updateModel() {
        FormComponent.updateCollectionModel((FormComponent)this);
    }

    protected final Collection<T> convertValue(String[] value) throws ConversionException {
        if (value != null && value.length > 0) {
            return this.convertIdsToChoices(Arrays.asList(value));
        }
        return Collections.emptyList();
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.getSettings().setMultiple(true);
    }

    protected String getModelValue() {
        Collection values = (Collection)this.getModelObject();
        if (values == null || values.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : values) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(this.getProvider().getIdValue(object));
        }
        return sb.toString();
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("multiple", (CharSequence)"multiple");
    }
}

