/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.timer;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.util.time.Duration;
import org.wicketstuff.push.IPushService;
import org.wicketstuff.push.IPushTarget;
import org.wicketstuff.push.timer.TimerChannelBehavior;

public class TimerPushService
implements IPushService {
    private static final long serialVersionUID = 1L;
    private final Duration duration;

    public TimerPushService(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("duration must not be null");
        }
        this.duration = duration;
    }

    public IPushTarget installPush(Component component) {
        TimerChannelBehavior tcb = new TimerChannelBehavior(this.duration);
        component.add(new IBehavior[]{tcb});
        return tcb.newPushTarget();
    }

    public void uninstallPush(Component component) {
        for (IBehavior behavior : component.getBehaviors()) {
            if (!(behavior instanceof TimerChannelBehavior)) continue;
            component.remove(behavior);
        }
    }

    public Duration getDuration() {
        return this.duration;
    }
}

