/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.timer;

import java.io.Serializable;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.util.time.Duration;
import org.wicketstuff.push.ChannelEvent;
import org.wicketstuff.push.IChannelListener;
import org.wicketstuff.push.IChannelPublisher;
import org.wicketstuff.push.IChannelService;
import org.wicketstuff.push.IPushTarget;
import org.wicketstuff.push.timer.EventStore;
import org.wicketstuff.push.timer.EventStoreListener;
import org.wicketstuff.push.timer.TimerChannelBehavior;
import org.wicketstuff.push.timer.TimerChannelPublisher;

public class TimerChannelService
implements IChannelService,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Duration duration;
    private final IChannelPublisher publisher = new TimerChannelPublisher();

    public TimerChannelService(Duration duration) {
        this.duration = duration;
    }

    public void addChannelListener(Component component, final String listenerChannel, final IChannelListener listener) {
        TimerChannelBehavior timerChannelBehavior = new TimerChannelBehavior(this.duration);
        final IPushTarget pushTarget = timerChannelBehavior.newPushTarget();
        component.add(new IBehavior[]{timerChannelBehavior});
        EventStore.get().addEventStoreListener(new EventStoreListener(){

            @Override
            public void EventTriggered(String eventChannel, Map<String, String> data) {
                if (listenerChannel.equals(eventChannel)) {
                    listener.onEvent(listenerChannel, data, pushTarget);
                    pushTarget.trigger();
                }
            }
        });
    }

    public void publish(ChannelEvent event) {
        this.publisher.publish(event);
    }
}

