/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.timer;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.LongValue;
import org.wicketstuff.push.IPushTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerChannelBehavior
extends AbstractAjaxTimerBehavior
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong COUNTER = new AtomicLong();
    private static Method[] methods;
    private static final int ADD_COMPONENT_METHOD = 0;
    private static final int ADD_COMPONENT_WITH_MARKUP_ID_METHOD = 1;
    private static final int APPEND_JAVASCRIPT_METHOD = 2;
    private static final int PREPEND_JAVASCRIPT_METHOD = 3;
    private static final int FOCUS_COMPONENT_METHOD = 4;
    static final Duration TIMEOUT_MARGIN;
    private final String id = String.valueOf(COUNTER.incrementAndGet());
    private final Duration timeout;
    static final MetaDataKey<ConcurrentMap<String, List<DelayedMethodCallList>>> TRIGGERS_KEY;
    static final MetaDataKey<ConcurrentMap<String, Time>> EVENTS_KEY;
    static final MetaDataKey<ConcurrentMap<String, String>> PAGE_ID_KEY;

    public TimerChannelBehavior(Duration updateInterval) {
        this(updateInterval, updateInterval.add(TIMEOUT_MARGIN));
    }

    public TimerChannelBehavior(Duration updateInterval, Duration timeout) {
        super(updateInterval);
        this.timeout = timeout;
    }

    protected void onBind() {
        super.onBind();
        TimerChannelBehavior.touch(this.getComponent().getApplication(), this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTimer(AjaxRequestTarget target) {
        ArrayList<DelayedMethodCallList> triggersCopy;
        List<DelayedMethodCallList> triggers;
        TimerChannelBehavior.touch(this.getComponent().getApplication(), this.id);
        List<DelayedMethodCallList> list = triggers = TimerChannelBehavior.getTriggers(this.getComponent().getApplication(), this.id);
        synchronized (list) {
            if (triggers.isEmpty()) {
                return;
            }
            triggersCopy = new ArrayList<DelayedMethodCallList>(triggers);
            triggers.clear();
        }
        for (DelayedMethodCallList dmcl : triggersCopy) {
            try {
                dmcl.invoke(target);
            }
            catch (Exception e) {
                throw new WicketRuntimeException("a problem occured while adding events to AjaxRequestTarget", (Throwable)e);
            }
        }
    }

    public IPushTarget newPushTarget() {
        return new TimerPushTarget(Application.get(), this.id, this.timeout);
    }

    public void renderHead(IHeaderResponse response) {
        TimerChannelBehavior.touch(this.getComponent().getApplication(), this.id);
        String timerChannelPageId = this.getComponent().getPage().getId() + ":updateInterval:" + this.getUpdateInterval();
        if (!TimerChannelBehavior.getPageId(this.getComponent().getApplication(), this.id).equals(this.id)) {
            return;
        }
        if (!response.wasRendered((Object)timerChannelPageId)) {
            super.renderHead(response);
            TimerChannelBehavior.setRedirectId(this.getComponent().getApplication(), timerChannelPageId, this.id);
            response.markRendered((Object)timerChannelPageId);
        } else {
            String redirectedId = TimerChannelBehavior.getPageId(this.getComponent().getApplication(), timerChannelPageId);
            TimerChannelBehavior.setRedirectId(this.getComponent().getApplication(), this.id, redirectedId);
        }
    }

    public static boolean isConnected(Application application, String id, Duration timeout) {
        boolean isConnected;
        Time time = TimerChannelBehavior.getLastPollEvent(application, id);
        if (time == null) {
            return false;
        }
        boolean bl = isConnected = time.elapsedSince().compareTo((LongValue)timeout) < 0;
        if (!isConnected) {
            TimerChannelBehavior.cleanMetadata(application, id);
        }
        return isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DelayedMethodCallList> getTriggers(Application application, String id) {
        ConcurrentHashMap triggersById;
        id = TimerChannelBehavior.getPageId(application, id);
        Application application2 = application;
        synchronized (application2) {
            triggersById = (ConcurrentHashMap)application.getMetaData(TRIGGERS_KEY);
            if (triggersById == null) {
                triggersById = new ConcurrentHashMap();
                application.setMetaData(TRIGGERS_KEY, triggersById);
            }
        }
        List triggers = (List)triggersById.get(id);
        if (triggers == null) {
            triggersById.putIfAbsent(id, new ArrayList());
            triggers = (List)triggersById.get(id);
        }
        return triggers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanMetadata(Application application, String id) {
        List triggers;
        id = TimerChannelBehavior.getPageId(application, id);
        ConcurrentMap triggersById = null;
        ConcurrentMap eventsTimeById = null;
        ConcurrentMap pageIdsById = null;
        Application application2 = application;
        synchronized (application2) {
            triggersById = (ConcurrentMap)application.getMetaData(TRIGGERS_KEY);
            eventsTimeById = (ConcurrentMap)application.getMetaData(EVENTS_KEY);
            pageIdsById = (ConcurrentMap)application.getMetaData(PAGE_ID_KEY);
        }
        if (triggersById != null && (triggers = (List)triggersById.remove(id)) != null) {
            List list = triggers;
            synchronized (list) {
                triggers.clear();
            }
        }
        if (eventsTimeById != null) {
            eventsTimeById.remove(id);
        }
        if (pageIdsById != null) {
            pageIdsById.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void touch(Application application, String id) {
        ConcurrentHashMap<String, Time> eventsTimeById;
        id = TimerChannelBehavior.getPageId(application, id);
        Application application2 = application;
        synchronized (application2) {
            eventsTimeById = (ConcurrentHashMap<String, Time>)application.getMetaData(EVENTS_KEY);
            if (eventsTimeById == null) {
                eventsTimeById = new ConcurrentHashMap<String, Time>();
                application.setMetaData(EVENTS_KEY, eventsTimeById);
            }
        }
        eventsTimeById.put(id, Time.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Time getLastPollEvent(Application application, String id) {
        ConcurrentMap eventsTimeById;
        id = TimerChannelBehavior.getPageId(application, id);
        Application application2 = application;
        synchronized (application2) {
            eventsTimeById = (ConcurrentMap)application.getMetaData(EVENTS_KEY);
            if (eventsTimeById == null) {
                return null;
            }
        }
        Time time = (Time)eventsTimeById.get(id);
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPageId(Application application, String id) {
        ConcurrentMap pageIdsById;
        Application application2 = application;
        synchronized (application2) {
            pageIdsById = (ConcurrentMap)application.getMetaData(PAGE_ID_KEY);
            if (pageIdsById == null) {
                return id;
            }
        }
        String pageId = (String)pageIdsById.get(id);
        return pageId == null ? id : pageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setRedirectId(Application application, String id, String redirectedId) {
        ConcurrentHashMap<String, String> pageIdsById;
        Application application2 = application;
        synchronized (application2) {
            pageIdsById = (ConcurrentHashMap<String, String>)application.getMetaData(PAGE_ID_KEY);
            if (pageIdsById == null) {
                pageIdsById = new ConcurrentHashMap<String, String>();
                application.setMetaData(PAGE_ID_KEY, pageIdsById);
            }
        }
        String oldRedirectedId = pageIdsById.put(id, redirectedId);
        if (!redirectedId.equals(oldRedirectedId)) {
            String idToRedirect = oldRedirectedId == null ? id : oldRedirectedId;
            TimerChannelBehavior.redirect(application, idToRedirect, redirectedId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void redirect(Application application, String idToRedirect, String redirectedId) {
        List triggersToRedirect;
        ConcurrentMap triggersById = null;
        ConcurrentMap eventsTimeById = null;
        Application application2 = application;
        synchronized (application2) {
            triggersById = (ConcurrentMap)application.getMetaData(TRIGGERS_KEY);
            eventsTimeById = (ConcurrentMap)application.getMetaData(EVENTS_KEY);
        }
        if (triggersById != null && (triggersToRedirect = (List)triggersById.remove(idToRedirect)) != null) {
            ArrayList triggersToRedirectCopy;
            List list = triggersToRedirect;
            synchronized (list) {
                triggersToRedirectCopy = new ArrayList(triggersToRedirect);
                triggersToRedirect.clear();
            }
            if (!triggersToRedirectCopy.isEmpty()) {
                List<DelayedMethodCallList> triggers;
                List<DelayedMethodCallList> list2 = triggers = TimerChannelBehavior.getTriggers(application, redirectedId);
                synchronized (list2) {
                    triggers.addAll(triggersToRedirectCopy);
                }
            }
        }
        if (eventsTimeById != null) {
            eventsTimeById.remove(idToRedirect);
        }
    }

    public String toString() {
        return "TimerChannelBehavior::" + this.id;
    }

    public String getId() {
        return this.id;
    }

    static {
        TIMEOUT_MARGIN = Duration.seconds((int)5);
        try {
            methods = new Method[]{AjaxRequestTarget.class.getMethod("addComponent", Component.class), AjaxRequestTarget.class.getMethod("addComponent", Component.class, String.class), AjaxRequestTarget.class.getMethod("appendJavascript", String.class), AjaxRequestTarget.class.getMethod("prependJavascript", String.class), AjaxRequestTarget.class.getMethod("focusComponent", Component.class)};
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Unable to initialize DefaultAjaxPushBehavior", (Throwable)e);
        }
        TRIGGERS_KEY = new MetaDataKey<ConcurrentMap<String, List<DelayedMethodCallList>>>(){
            private static final long serialVersionUID = 1L;
        };
        EVENTS_KEY = new MetaDataKey<ConcurrentMap<String, Time>>(){
            private static final long serialVersionUID = 1L;
        };
        PAGE_ID_KEY = new MetaDataKey<ConcurrentMap<String, String>>(){
            private static final long serialVersionUID = 1L;
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimerPushTarget
    implements IPushTarget {
        private final DelayedMethodCallList currentTrigger = new DelayedMethodCallList();
        private final Application application;
        private final String id;
        private final Duration timeout;

        public TimerPushTarget(Application application, String id, Duration timeout) {
            this.application = application;
            this.id = id;
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addComponent(Component component) {
            DelayedMethodCallList delayedMethodCallList = this.currentTrigger;
            synchronized (delayedMethodCallList) {
                this.currentTrigger.addCall(0, new Object[]{component});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addComponent(Component component, String markupId) {
            DelayedMethodCallList delayedMethodCallList = this.currentTrigger;
            synchronized (delayedMethodCallList) {
                this.currentTrigger.addCall(1, new Object[]{component, markupId});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendJavascript(String javascript) {
            DelayedMethodCallList delayedMethodCallList = this.currentTrigger;
            synchronized (delayedMethodCallList) {
                this.currentTrigger.addCall(2, new Object[]{javascript});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void focusComponent(Component component) {
            DelayedMethodCallList delayedMethodCallList = this.currentTrigger;
            synchronized (delayedMethodCallList) {
                this.currentTrigger.addCall(4, new Object[]{component});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void prependJavascript(String javascript) {
            DelayedMethodCallList delayedMethodCallList = this.currentTrigger;
            synchronized (delayedMethodCallList) {
                this.currentTrigger.addCall(3, new Object[]{javascript});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trigger() {
            List<DelayedMethodCallList> triggers;
            DelayedMethodCallList trigger = null;
            DelayedMethodCallList delayedMethodCallList = this.currentTrigger;
            synchronized (delayedMethodCallList) {
                if (this.currentTrigger.isEmpty()) {
                    return;
                }
                trigger = new DelayedMethodCallList(this.currentTrigger);
                this.currentTrigger.clear();
            }
            List<DelayedMethodCallList> list = triggers = this.getTriggers();
            synchronized (list) {
                triggers.add(trigger);
            }
        }

        @Override
        public boolean isConnected() {
            return TimerChannelBehavior.isConnected(this.application, this.id, this.timeout);
        }

        private List<DelayedMethodCallList> getTriggers() {
            return TimerChannelBehavior.getTriggers(this.application, this.id);
        }
    }

    private static class DelayedMethodCallList
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Application _application = Application.get();
        private final List<DelayedMethodCall> calls;

        public DelayedMethodCallList() {
            this.calls = new ArrayList<DelayedMethodCall>();
        }

        public DelayedMethodCallList(DelayedMethodCallList dmcl) {
            this.calls = new ArrayList<DelayedMethodCall>(dmcl.calls);
        }

        public void addCall(int m, Object[] parameters) {
            this.calls.add(new DelayedMethodCall(m, parameters));
        }

        public void invoke(Object o) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            for (DelayedMethodCall dmc : this.calls) {
                dmc.invoke(o);
            }
        }

        public boolean isEmpty() {
            return this.calls.isEmpty();
        }

        public void clear() {
            this.calls.clear();
        }

        private class DelayedMethodCall
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final int m;
            private final Object[] parameters;

            public DelayedMethodCall(int m, Object[] parameters) {
                this.m = m;
                this.parameters = parameters;
            }

            public void invoke(Object o) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                Application.set((Application)DelayedMethodCallList.this._application);
                methods[this.m].invoke(o, this.parameters);
                Application.unset();
            }
        }
    }
}

