/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.dojo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.wicketstuff.push.dojo.AbstractRequireDojoBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetRefresherManager
implements AjaxRequestTarget.IListener {
    private static TargetRefresherManager instance;
    private Map<String, Component> dojoComponents = new HashMap<String, Component>();

    private TargetRefresherManager() {
    }

    public static TargetRefresherManager getInstance() {
        if (instance == null) {
            instance = new TargetRefresherManager();
        }
        return instance;
    }

    public void onAfterRespond(Map<String, Component> map, AjaxRequestTarget.IJavascriptResponse response) {
        HashMap<String, Component> real = new HashMap<String, Component>();
        String requires = "";
        for (Component c : this.dojoComponents.values()) {
            for (IBehavior behavior : c.getBehaviors()) {
                if (!(behavior instanceof AbstractRequireDojoBehavior)) continue;
                requires = requires + ((AbstractRequireDojoBehavior)behavior).getRequire();
            }
        }
        this.dojoComponents = real;
        if (this.generateReParseJs() != null) {
            response.addJavascript(requires + this.generateReParseJs());
        }
        instance = null;
    }

    public void onBeforeRespond(Map<String, Component> map, AjaxRequestTarget target) {
    }

    public void addComponent(Component component) {
        this.dojoComponents.put(component.getMarkupId(), component);
    }

    private String generateReParseJs() {
        if (!this.dojoComponents.isEmpty()) {
            Iterator<Component> it = this.dojoComponents.values().iterator();
            String parseJs = "[";
            while (it.hasNext()) {
                Component c = it.next();
                parseJs = parseJs + "'" + c.getMarkupId() + "',";
            }
            parseJs = parseJs.substring(0, parseJs.length() - 1);
            parseJs = parseJs + "]";
            return "djConfig.searchIds = " + parseJs + ";dojo.hostenv.makeWidgets();";
        }
        return null;
    }
}

