/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.dojo;

import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;

public abstract class AbstractDefaultDojoBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    public static final MetaDataKey<CompressedResourceReference> USE_CUSTOM_DOJO_DIST = new MetaDataKey<CompressedResourceReference>(){
        private static final long serialVersionUID = 1L;
    };
    public static final ResourceReference DOJO = new CompressedResourceReference(AbstractDefaultDojoBehavior.class, "dojo/dojo.js");
    private static final String COMETD_DOJO_CONFIG_ID = AbstractDefaultDojoBehavior.class.getName() + "::debug";

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        StringBuffer dojoConfig = new StringBuffer();
        dojoConfig.append("var djConfig = {};\n");
        String configurationType = Application.get().getConfigurationType();
        if (configurationType.equalsIgnoreCase("development")) {
            dojoConfig.append("djConfig.isDebug = true;\n");
            dojoConfig.append("djConfig.parseOnLoad = true;\n");
        } else {
            dojoConfig.append("djConfig.isDebug = false;\n");
        }
        response.renderJavascript((CharSequence)dojoConfig.toString(), COMETD_DOJO_CONFIG_ID);
        response.renderJavascriptReference(this.getDojoResourceReference());
    }

    public ResourceReference getDojoResourceReference() {
        if (Application.get().getMetaData(USE_CUSTOM_DOJO_DIST) == null || !(Application.get().getMetaData(USE_CUSTOM_DOJO_DIST) instanceof CompressedResourceReference)) {
            return DOJO;
        }
        return (ResourceReference)Application.get().getMetaData(USE_CUSTOM_DOJO_DIST);
    }
}

