/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.cometd;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.protocol.http.WebApplication;
import org.cometd.Bayeux;
import org.cometd.Channel;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.Message;
import org.cometd.MessageListener;
import org.cometd.RemoveListener;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.ContinuationBayeux;
import org.wicketstuff.push.ChannelEvent;
import org.wicketstuff.push.IChannelListener;
import org.wicketstuff.push.IChannelService;
import org.wicketstuff.push.cometd.CometdBehavior;

public class CometdService
implements IChannelService {
    public static final String BAYEUX_CLIENT_PREFIX = "wicket-push";
    private final Map<String, RemoveListener> removalListeners;
    final WebApplication _application;
    private Bayeux _bayeux;
    private Client serviceClient;
    private boolean listeningToConnect;

    public CometdService(WebApplication application) {
        this._application = application;
        this.removalListeners = Collections.synchronizedMap(new WeakHashMap());
        this.listeningToConnect = false;
    }

    public void addChannelListener(Component component, String channel, IChannelListener listener) {
        component.add(new IBehavior[]{new CometdBehavior(channel, listener)});
    }

    public void addChannelRemoveListener(String chnl, RemoveListener listener, Session sess) {
        if (!this.listeningToConnect) {
            this.getBayeux().getChannel("/meta/subscribe", true).subscribe(this.serviceClient);
            this.serviceClient.addListener((ClientListener)new RemovalForwardingListener());
            this.listeningToConnect = true;
        }
        this.removalListeners.put("/" + chnl, new RemovalListener(listener, sess));
    }

    public void addChannelRemoveListener(String chnl, RemoveListener listener) {
        this.addChannelRemoveListener(chnl, listener, null);
    }

    public void publish(ChannelEvent event) {
        event.addData("proxy", "true");
        String channelId = "/" + event.getChannel();
        Channel channel = this.getBayeux().getChannel(channelId, true);
        channel.publish(this.serviceClient, event.getData(), event.getId());
    }

    private final Bayeux getBayeux() {
        if (this._bayeux == null) {
            this.initBayeux();
        }
        return this._bayeux;
    }

    private void initBayeux() {
        String cfgType = this._application.getConfigurationType();
        this._bayeux = (Bayeux)this._application.getServletContext().getAttribute("org.cometd.bayeux");
        if (this._bayeux instanceof AbstractBayeux && "development".equalsIgnoreCase(cfgType)) {
            ((AbstractBayeux)this._bayeux).setLogLevel(2);
        }
        if (this._bayeux instanceof ContinuationBayeux) {
            ((ContinuationBayeux)this._bayeux).setJSONCommented(true);
        }
        this.serviceClient = this._bayeux.newClient(BAYEUX_CLIENT_PREFIX);
    }

    public Application getApplication() {
        return this._application;
    }

    private final class RemovalListener
    implements RemoveListener {
        private final RemoveListener removeListener;
        private final Session sess;

        public RemovalListener(RemoveListener listener, Session sess) {
            this.removeListener = listener;
            this.sess = sess;
        }

        public void removed(String clientId, boolean timeout) {
            boolean hasNoSession;
            boolean hasNoApp = !Application.exists();
            boolean bl = hasNoSession = !Session.exists();
            if (hasNoApp) {
                Application.set((Application)CometdService.this.getApplication());
            }
            if (hasNoSession && this.sess != null) {
                Session.set((Session)this.sess);
            }
            this.removeListener.removed(clientId, timeout);
            if (hasNoApp) {
                Application.unset();
            }
            if (hasNoSession) {
                Session.unset();
            }
        }
    }

    private final class RemovalForwardingListener
    implements MessageListener {
        private RemovalForwardingListener() {
        }

        public void deliver(Client fromClient, Client toClient, Message msg) {
            String channel = (String)msg.get((Object)"subscription");
            if (CometdService.this.removalListeners.containsKey(channel)) {
                fromClient.addListener((ClientListener)CometdService.this.removalListeners.get(channel));
            }
        }
    }
}

