/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.cometd;

import java.io.InputStream;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.parser.XmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.protocol.http.WebApplication;
import org.mortbay.cometd.continuation.ContinuationCometdServlet;
import org.wicketstuff.push.dojo.AbstractRequireDojoBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CometdAbstractBehavior
extends AbstractRequireDojoBehavior {
    private static final long serialVersionUID = 1L;
    private static final String cometdServletPath = CometdAbstractBehavior.getCometdServletPath();
    private static short idex = (short)97;
    private String channelId;
    private final short index;

    public CometdAbstractBehavior(String channelId) {
        this.channelId = channelId;
        short s = idex;
        idex = (short)(s + 1);
        this.index = s;
    }

    @Override
    public void setRequire(Set<String> libs) {
        libs.add("dojo._base");
        libs.add("dojox.cometd");
        libs.add("dojox.cometd.timestamp");
        libs.add("dojox.cometd.timesync");
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.channelId == null) {
            throw new IllegalArgumentException("ChannelId in a CometdBehavior can not be null");
        }
        response.renderJavascript(this.getInitCometdScript(), "initCometd");
        String cometdInterceptorScript = this.getCometdInterceptorScript();
        if (cometdInterceptorScript != null) {
            response.renderJavascript((CharSequence)cometdInterceptorScript, "Interceptor" + this.getBehaviorMarkupId());
        }
        response.renderJavascript(this.getSubscriberScript(), "Subscribe" + this.getBehaviorMarkupId());
    }

    public abstract String getCometdInterceptorScript();

    public abstract CharSequence getPartialSubscriber();

    protected final CharSequence getInitCometdScript() {
        return "dojox.cometd.init('" + cometdServletPath + "')\n";
    }

    public final CharSequence getSubscriberScript() {
        return "dojox.cometd.subscribe('/" + this.getChannelId() + "', " + this.getPartialSubscriber() + ");\n";
    }

    public final CharSequence getUnsuscribeScript() {
        return "dojox.cometd.unsubscribe('/" + this.getChannelId() + "');\n";
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public final CharSequence getBehaviorMarkupId() {
        StringBuilder sb = new StringBuilder(this.getComponent().getMarkupId());
        return sb.append(this.getChannelId()).append(this.index).toString();
    }

    protected static String getCometdServletPath() {
        ServletContext servletContext = ((WebApplication)Application.get()).getServletContext();
        InputStream is = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        try {
            XmlTag elem;
            XmlPullParser parser = new XmlPullParser();
            parser.parse(is);
            String urlPattern = null;
            while (!((elem = (XmlTag)parser.nextTag()) == null || elem.getName().equals("servlet") && elem.isOpen())) {
            }
            if (elem != null) {
                String servletName = null;
                String servletClass = null;
                do {
                    if ((elem = (XmlTag)parser.nextTag()).isOpen()) {
                        parser.setPositionMarker();
                        continue;
                    }
                    if (elem.isClose() && elem.getName().equals("servlet-name")) {
                        servletName = ((Object)parser.getInputFromPositionMarker(elem.getPos())).toString();
                        continue;
                    }
                    if (!elem.isClose() || !elem.getName().equals("servlet-class")) continue;
                    servletClass = ((Object)parser.getInputFromPositionMarker(elem.getPos())).toString();
                } while (servletClass == null || !ContinuationCometdServlet.class.isAssignableFrom(Class.forName(servletClass)));
                while (!((elem = (XmlTag)parser.nextTag()) == null || elem.getName().equals("servlet-mapping") && elem.isOpen())) {
                }
                if (elem != null) {
                    String servletNameMapping = null;
                    do {
                        if ((elem = (XmlTag)parser.nextTag()).isOpen()) {
                            parser.setPositionMarker();
                            continue;
                        }
                        if (!elem.isClose() || !elem.getName().equals("servlet-name")) continue;
                        servletNameMapping = ((Object)parser.getInputFromPositionMarker(elem.getPos())).toString();
                    } while (!servletName.equals(servletNameMapping));
                    do {
                        if ((elem = (XmlTag)parser.nextTag()).isOpen()) {
                            parser.setPositionMarker();
                            continue;
                        }
                        if (!elem.isClose() || !elem.getName().equals("url-pattern")) continue;
                        urlPattern = ((Object)parser.getInputFromPositionMarker(elem.getPos())).toString();
                    } while (urlPattern == null);
                }
            }
            if (urlPattern == null) {
                throw new ServletException("Error searching for cometd Servlet");
            }
            if (!urlPattern.startsWith("/") || !urlPattern.endsWith("/*")) {
                throw new ServletException("Url pattern for cometd should start with / and finish with /*");
            }
            String path = urlPattern.substring(0, urlPattern.length() - 2);
            return servletContext.getContextPath() + path;
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Error finding filter cometd servlet in web.xml", (Throwable)e);
        }
    }
}

