/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.flot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.wicketstuff.flot.Color;
import org.wicketstuff.flot.DataSet;
import org.wicketstuff.flot.GraphType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Series
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger logger = Logger.getLogger(Series.class);
    String label;
    Color color;
    Set<GraphType> graphTypes;
    List<DataSet> data;

    public Series(List<DataSet> data, String label, Color color, Set<GraphType> graphTypes) {
        this.label = label;
        this.color = color;
        this.graphTypes = new HashSet<GraphType>(graphTypes);
        this.data = new ArrayList<DataSet>(data);
    }

    public Series(List<DataSet> data, String label, Color color, GraphType ... graphTypes) {
        this(data, label, color, new HashSet<GraphType>(Arrays.asList(graphTypes)));
    }

    public String getLabel() {
        return this.label;
    }

    public List<DataSet> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("{data: [");
        for (DataSet dataSet : this.getData()) {
            str.append(dataSet.toString());
            str.append(", ");
        }
        if (this.getData().size() > 0) {
            str.setLength(str.length() - 2);
        }
        str.append("], label: \"" + this.getLabel() + "\", color: \"" + this.color.html() + "\"");
        if (this.graphTypes.size() > 0) {
            str.append(", ");
        }
        for (GraphType graphType : this.graphTypes) {
            str.append(graphType);
            str.append(", ");
        }
        if (this.graphTypes.size() > 0) {
            str.setLength(str.length() - 2);
            str.append("}");
        }
        logger.info((Object)("Series: " + str));
        return str.toString();
    }

    public Series addDataSet(DataSet dataSet, Color color) {
        ArrayList<DataSet> newData = new ArrayList<DataSet>(this.data);
        newData.add(dataSet);
        return new Series(newData, this.label, color, this.graphTypes);
    }
}

