/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.flot;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.IModel;
import org.wicketstuff.flot.Color;
import org.wicketstuff.flot.LegendPosition;
import org.wicketstuff.flot.Series;
import org.wicketstuff.flot.TickCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlotPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(FlotPanel.class);
    private Map<String, Map<String, Object>> options = new HashMap<String, Map<String, Object>>();
    private boolean showTooltip = false;

    public FlotPanel(String id, IModel<List<Series>> model) {
        super(id, model);
        String[] optionsKeys;
        for (String key : optionsKeys = new String[]{"lines", "points", "legend", "xaxis", "yaxis", "x2axis", "y2axis", "selection", "grid"}) {
            this.options.put(key, new HashMap());
        }
        this.options.get("selection").put("mode", "xy");
        this.options.get("grid").put("hoverable", true);
        this.options.get("grid").put("clickable", true);
        this.add(new Component[]{new WebComponent("flotScript"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                this.replaceComponentTagBody(markupStream, openTag, FlotPanel.this.getFlotScript());
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.setType(XmlTag.OPEN);
            }
        }});
    }

    private String getFlotScript() {
        try {
            String str = FlotPanel.getResourceContents(FlotPanel.class, "FlotPanel.js");
            logger.info(this.options);
            List data = (List)this.getDefaultModelObject();
            StringBuffer strData = new StringBuffer();
            strData.append("[");
            for (Series dataEntry : data) {
                strData.append(dataEntry.toString());
                strData.append(", ");
            }
            if (data.size() > 0) {
                strData.setLength(strData.length() - 2);
            }
            strData.append("]");
            String strOptions = FlotPanel.mapToString(this.options);
            return String.format(str, strData, strOptions, this.showTooltip ? "true" : "false");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load FlotPanel.js", e);
        }
    }

    private static String mapToString(Map<?, ?> map) {
        StringBuilder str = new StringBuilder();
        str.append("{");
        Set<?> keySet = map.keySet();
        for (Object key : keySet) {
            str.append(key);
            str.append(": ");
            Object value = map.get(key);
            if (Map.class.isAssignableFrom(value.getClass())) {
                str.append(FlotPanel.mapToString((Map)value));
            } else {
                boolean valueIsString = value.getClass().equals(String.class);
                if (valueIsString) {
                    str.append("\"");
                }
                str.append(value);
                if (valueIsString) {
                    str.append("\"");
                }
            }
            str.append(", ");
        }
        if (keySet.size() > 0) {
            str.setLength(str.length() - 2);
        }
        str.append("}");
        return str.toString();
    }

    public void setAxisTimeModeX(boolean timeMode) {
        String mode = timeMode ? "time" : "null";
        this.options.get("xaxis").put("mode", mode);
    }

    public void setAxisTimeformatX(String timeFormat) {
        this.options.get("xaxis").put("timeformat", timeFormat);
    }

    public void setAxisMinX(Double axisMinX) {
        this.options.get("xaxis").put("min", axisMinX);
    }

    public Double getAxisMinX() {
        return (Double)this.options.get("xaxis").get("min");
    }

    public void setAxisMinY(Double axisMinY) {
        this.options.get("yaxis").put("min", axisMinY);
    }

    public Double getAxisMinY() {
        return (Double)this.options.get("yaxis").get("min");
    }

    public void setAxisMaxX(Double axisMaxX) {
        this.options.get("xaxis").put("max", axisMaxX);
    }

    public Double getAxisMaxX() {
        return (Double)this.options.get("xaxis").get("max");
    }

    public void setAxisMaxY(Double axisMaxY) {
        this.options.get("yaxis").put("max", axisMaxY);
    }

    public Double getAxisMaxY() {
        return (Double)this.options.get("yaxis").get("max");
    }

    public void setAxisTicksX(TickCollection tickCollection) {
        this.options.get("xaxis").put("ticks", tickCollection);
    }

    public TickCollection getAxisTicksX() {
        return (TickCollection)this.options.get("xaxis").get("ticks");
    }

    public void setAxisTicksY(TickCollection tickCollection) {
        this.options.get("yaxis").put("ticks", tickCollection);
    }

    public TickCollection getAxisTicksY() {
        return (TickCollection)this.options.get("yaxis").get("ticks");
    }

    public void setLegendPosition(LegendPosition position) {
        this.options.get("legend").put("position", position.getPosition());
    }

    public LegendPosition getLegendPosition() {
        return LegendPosition.toLegendPosition((String)this.options.get("legend").get("position"));
    }

    public void setForegroundColor(Color color) {
        this.options.get("grid").put("color", color);
    }

    public Color getForegroundColor() {
        return (Color)this.options.get("grid").get("color");
    }

    public void setBackgroundColor(Color color) {
        this.options.get("grid").put("backgroundColor", color);
    }

    public Color getBackgroundColor() {
        return (Color)this.options.get("grid").get("backgroundColor");
    }

    public void setTickColor(Color color) {
        this.options.get("grid").put("tickColor", color);
    }

    public Color getTickColor() {
        return (Color)this.options.get("grid").get("tickColor");
    }

    public void setClickable(boolean clickable) {
        this.options.get("grid").put("clickable", clickable);
    }

    public boolean getClickable() {
        return (Boolean)this.options.get("grid").get("clickable");
    }

    public boolean getHoverable() {
        return (Boolean)this.options.get("grid").get("hoverable");
    }

    public void setHoverable(boolean hoverable) {
        this.options.get("grid").put("hoverable", hoverable);
    }

    public void showTooltip(boolean showTooltip) {
        this.showTooltip = showTooltip;
        if (showTooltip) {
            this.setHoverable(true);
        }
    }

    private static String getResourceContents(Class<?> clazz, String location) throws IOException {
        InputStream in = clazz.getResourceAsStream(location);
        if (in == null) {
            throw new FileNotFoundException("'" + location + "' not found.");
        }
        return FlotPanel.getStreamContents(new InputStreamReader(in));
    }

    private static String getStreamContents(InputStreamReader inputStreamReader) throws IOException {
        String line;
        StringBuffer str = new StringBuffer();
        BufferedReader in = new BufferedReader(inputStreamReader);
        while ((line = in.readLine()) != null) {
            str.append(line);
            str.append("\n");
        }
        return str.toString();
    }
}

