/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import com.google.inject.Inject;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.MBean;
import org.weakref.jmx.MBeanBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanExporter {
    private final MBeanServer server;
    private final Set<String> exportedObjectNames = new HashSet<String>();

    MBeanExporter() {
        this(ManagementFactory.getPlatformMBeanServer());
    }

    @Inject
    public MBeanExporter(MBeanServer server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String name, Object object) {
        try {
            ObjectName objectName = new ObjectName(name);
            MBeanBuilder builder = new MBeanBuilder(object);
            MBean mbean = builder.build();
            Set<String> set = this.exportedObjectNames;
            synchronized (set) {
                this.exportedObjectNames.add(name);
                this.server.registerMBean(mbean, objectName);
            }
        }
        catch (MalformedObjectNameException e) {
            throw new JmxException(JmxException.Reason.MALFORMED_OBJECT_NAME, e.getMessage(), new Object[0]);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new JmxException(JmxException.Reason.INSTANCE_ALREADY_EXISTS, e.getMessage(), new Object[0]);
        }
        catch (MBeanRegistrationException e) {
            throw new JmxException(JmxException.Reason.MBEAN_REGISTRATION, e.getMessage(), e.getCause());
        }
        catch (NotCompliantMBeanException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unexport(String name) {
        try {
            ObjectName objectName = new ObjectName(name);
            Set<String> set = this.exportedObjectNames;
            synchronized (set) {
                this.server.unregisterMBean(objectName);
                this.exportedObjectNames.remove(name);
            }
        }
        catch (MalformedObjectNameException e) {
            throw new JmxException(JmxException.Reason.MALFORMED_OBJECT_NAME, e.getMessage(), new Object[0]);
        }
        catch (MBeanRegistrationException e) {
            throw new JmxException(JmxException.Reason.MBEAN_REGISTRATION, e.getMessage(), e.getCause());
        }
        catch (InstanceNotFoundException e) {
            throw new JmxException(JmxException.Reason.INSTANCE_NOT_FOUND, e.getMessage(), new Object[0]);
        }
    }

    @Deprecated
    public void unexportAll() {
        this.unexportAllAndReportMissing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Exception> unexportAllAndReportMissing() {
        HashMap<String, Exception> errors = new HashMap<String, Exception>();
        Set<String> set = this.exportedObjectNames;
        synchronized (set) {
            ArrayList<String> toRemove = new ArrayList<String>(this.exportedObjectNames.size());
            for (String objectName : this.exportedObjectNames) {
                try {
                    this.server.unregisterMBean(new ObjectName(objectName));
                    toRemove.add(objectName);
                }
                catch (InstanceNotFoundException e) {
                    toRemove.add(objectName);
                }
                catch (MalformedObjectNameException e) {
                    throw new IllegalStateException(String.format("Found a malformed object name [%s]. This should never happen", objectName), e);
                }
                catch (MBeanRegistrationException e) {
                    errors.put(objectName, e);
                }
            }
            this.exportedObjectNames.removeAll(toRemove);
        }
        return errors;
    }

    public static MBeanExporter withPlatformMBeanServer() {
        return new MBeanExporter(ManagementFactory.getPlatformMBeanServer());
    }
}

