/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vesalainen.util.navi.Scalar;
import org.vesalainen.util.navi.ScalarType;

public class TimeSpan
extends Scalar {
    public static final Pattern FORMAT = Pattern.compile("([0-9]+):([0-9]+):([0-9]+):([0-9]+)");

    public TimeSpan(String str) {
        super(ScalarType.TIMESPAN);
        Matcher mm = FORMAT.matcher(str);
        if (!mm.matches()) {
            throw new IllegalArgumentException(str + " is not a TimeSpan!");
        }
        int d = Integer.parseInt(mm.group(1));
        int h = Integer.parseInt(mm.group(2));
        int m = Integer.parseInt(mm.group(3));
        int s = Integer.parseInt(mm.group(4));
        this.value = d * 24 * 60 * 60 * 1000 + h * 60 * 60 * 1000 + m * 60 * 1000 + s * 1000;
    }

    public TimeSpan(long millis) {
        super(millis, ScalarType.TIMESPAN);
    }

    public TimeSpan(double millis) {
        super(millis, ScalarType.TIMESPAN);
    }

    public TimeSpan(long amount, TimeUnit timeUnit) {
        super(timeUnit.toMillis(amount), ScalarType.TIMESPAN);
    }

    public TimeSpan(double amount, TimeUnit timeUnit) {
        super(timeUnit.toMillis((long)amount), ScalarType.TIMESPAN);
    }

    public TimeSpan(Date from, Date to) {
        super(to.getTime() - from.getTime(), ScalarType.TIMESPAN);
    }

    Date addDate(Date from) {
        return new Date(from.getTime() + (long)this.value);
    }

    public long getMillis() {
        return (long)this.value;
    }

    public double getSeconds() {
        return this.value / 1000.0;
    }

    public long get(TimeUnit unit) {
        return unit.convert((long)this.value, TimeUnit.MILLISECONDS);
    }

    @Override
    public String toString() {
        long tt = (long)this.getSeconds();
        double sign = Math.signum(tt);
        tt = Math.abs(tt);
        int ss = (int)(tt % 60L);
        int mm = (int)((tt /= 60L) % 60L);
        int hh = (int)((tt /= 60L) % 60L);
        tt /= 24L;
        if (sign < 0.0) {
            return String.format("-%d:%02d:%02d:%02d", tt, hh, mm, ss);
        }
        return String.format("%d:%02d:%02d:%02d", tt, hh, mm, ss);
    }

    public static void main(String ... args) {
        try {
            TimeSpan ss = new TimeSpan(-1L, TimeUnit.HOURS);
            TimeSpanFormat tsf = new TimeSpanFormat("d:hh:mm:ss");
            System.err.println(tsf.format(ss));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class TimeSpanFormat {
        private String format;

        public TimeSpanFormat(String frm) {
            this.format = frm.replace("d", "%1$d");
            this.format = this.format.replace("hh", "%2$02d");
            this.format = this.format.replace("mm", "%3$02d");
            this.format = this.format.replace("ss", "%4$02d");
        }

        public final String format(TimeSpan ts) {
            long tt = (long)ts.getSeconds();
            double sign = Math.signum(tt);
            tt = Math.abs(tt);
            int ss = (int)(tt % 60L);
            int mm = (int)((tt /= 60L) % 60L);
            int hh = (int)((tt /= 60L) % 60L);
            tt /= 24L;
            if (sign < 0.0) {
                return String.format("-" + this.format, tt, hh, mm, ss);
            }
            return String.format(this.format, tt, hh, mm, ss);
        }
    }
}

