/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import java.util.Random;

public class SimpleStats {
    private double average;
    private double deviationSquare;
    private double max = Double.MIN_VALUE;
    private double min = Double.MAX_VALUE;
    private int count;

    public SimpleStats() {
    }

    public SimpleStats(SimpleStats a) {
        this.average = a.average;
        this.count = a.count;
        this.deviationSquare = a.deviationSquare;
        this.max = a.max;
        this.min = a.min;
    }

    public SimpleStats(SimpleStats a1, SimpleStats a2) {
        this.count = a1.count + a2.count;
        this.average = ((double)a1.count * a1.average + (double)a2.count * a2.average) / (double)this.count;
        this.deviationSquare = ((double)a1.count * a1.deviationSquare + (double)a2.count * a2.deviationSquare) / (double)this.count;
        this.max = Math.max(a1.max, a2.max);
        this.min = Math.min(a1.min, a2.min);
    }

    public SimpleStats(double min, double max, int count) {
        this(min, max, count, System.currentTimeMillis());
    }

    public SimpleStats(double min, double max, int count, long seed) {
        if (max < min) {
            throw new IllegalArgumentException(max + " < " + min);
        }
        double range = max - min;
        Random rand = new Random(seed);
        for (int ii = 0; ii < count; ++ii) {
            this.add(min + range * rand.nextDouble());
        }
    }

    public void add(double ... value) {
        for (double v : value) {
            this.add(v);
        }
    }

    public void add(double value) {
        this.max = Math.max(this.max, value);
        this.min = Math.min(this.min, value);
        if (this.count == 0) {
            this.average = value;
        } else {
            this.average = (double)this.count * this.average / (double)(this.count + 1) + value / (double)(this.count + 1);
            this.deviationSquare = (double)this.count * this.deviationSquare / (double)(this.count + 1) + Math.pow(value - this.average, 2.0) / (double)(this.count + 1);
        }
        ++this.count;
    }

    public double getAverage() {
        return this.average;
    }

    public double getDeviation() {
        return Math.sqrt(this.deviationSquare);
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getRange() {
        return this.max - this.min;
    }

    public void clear() {
        this.count = 0;
        this.average = 0.0;
        this.max = Double.MIN_VALUE;
        this.min = Double.MAX_VALUE;
        this.deviationSquare = 0.0;
    }

    public String toString() {
        return Double.toString(this.average);
    }
}

