/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.vesalainen.util.navi.ScalarType;

public class Scalar
implements Comparable<Scalar>,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final Scalar NaN = new Scalar(Double.NaN, ScalarType.UNKNOWN);
    public static final double Epsilon = 1.0E-4;
    protected static final double Kilo = 1000.0;
    protected static final double NMInMeters = 1852.0;
    protected static final double FeetInMeters = 0.3048;
    protected static final double FathomInMeters = 1.8288;
    protected static final double HoursInSecond = TimeUnit.HOURS.toSeconds(1L);
    protected double value;
    protected ScalarType type;

    private Scalar() {
    }

    protected Scalar(ScalarType type) {
        this.type = type;
    }

    protected Scalar(double value, ScalarType type) {
        this.value = value;
        this.type = type;
    }

    public Scalar(Scalar scalar) {
        if (!this.type.equals((Object)scalar.type)) {
            throw new UnsupportedOperationException("Action with wrong kind of class");
        }
        this.value = scalar.value;
    }

    void copy(Scalar scalar) {
        if (!this.type.equals((Object)scalar.type)) {
            throw new UnsupportedOperationException("Action with wrong kind of class");
        }
        this.value = scalar.value;
    }

    public boolean isNan() {
        return Double.isNaN(this.value);
    }

    public boolean equals(Scalar scalar, double maxDifference) {
        if (!this.type.equals((Object)scalar.type)) {
            throw new UnsupportedOperationException("Action with wrong kind of class");
        }
        return Math.abs(this.value - scalar.value) < maxDifference;
    }

    public boolean equals(Object ob) {
        if (ob instanceof Scalar) {
            Scalar scalar = (Scalar)ob;
            return this.equals(scalar, 1.0E-4);
        }
        throw new UnsupportedOperationException("equals not possible with " + ob.getClass().getName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (int)(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.value) >>> 32);
        return hash;
    }

    @Override
    public int compareTo(Scalar o) {
        if (!this.type.equals((Object)o.type)) {
            throw new UnsupportedOperationException("Action with wrong kind of class");
        }
        return Double.compare(this.value, o.value);
    }

    void add(double x) {
        this.value += x;
    }

    void add(Scalar o) {
        if (!this.type.equals((Object)o.type)) {
            throw new UnsupportedOperationException("Action with wrong kind of class");
        }
        this.value += o.value;
    }

    void subtract(double x) {
        this.value -= x;
    }

    void subtract(Scalar o) {
        if (!this.type.equals((Object)o.type)) {
            throw new UnsupportedOperationException("Action with wrong kind of class");
        }
        this.value -= o.value;
    }

    void mul(double x) {
        this.value *= x;
    }

    void plusPlus() {
        this.value += 1.0;
    }

    public boolean gt(Scalar o) {
        return this.compareTo(o) > 0;
    }

    public boolean lt(Scalar o) {
        return this.compareTo(o) < 0;
    }

    public boolean ge(Scalar o) {
        return this.compareTo(o) >= 0;
    }

    public boolean le(Scalar o) {
        return this.compareTo(o) <= 0;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public double getValue() {
        return this.value;
    }
}

