/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import java.util.concurrent.TimeUnit;
import org.vesalainen.util.navi.Angle;
import org.vesalainen.util.navi.Distance;
import org.vesalainen.util.navi.Motion;
import org.vesalainen.util.navi.Scalar;
import org.vesalainen.util.navi.ScalarType;
import org.vesalainen.util.navi.TimeSpan;
import org.vesalainen.util.navi.Velocity;

public class RateOfTurn
extends Scalar {
    public RateOfTurn() {
        super(ScalarType.TURN);
    }

    public RateOfTurn(double radiansPerSecond) {
        super(radiansPerSecond, ScalarType.TURN);
    }

    public RateOfTurn(Scalar scalar) {
        super(scalar);
    }

    public boolean isRight() {
        return this.value >= 0.0;
    }

    public double getDegreesPerMinute() {
        return Math.toDegrees(Math.abs(this.value)) * 60.0;
    }

    public TimeSpan getTimeForFullCircle() {
        return new TimeSpan(this.getSecondsForFullCircle(), TimeUnit.SECONDS);
    }

    public double getSecondsForFullCircle() {
        return Math.PI * 2 / Math.abs(this.value);
    }

    public Distance getRadius(Velocity velocity) {
        Distance circle = velocity.getDistance(this.getTimeForFullCircle());
        circle.mul(0.3183098861837907);
        return circle;
    }

    public Angle getBearingAfter(Angle bearing, TimeSpan span) {
        return bearing.add(this.getAngleChange(span));
    }

    public Angle getAngleChange(TimeSpan span) {
        return new Angle(span.getSeconds() * this.value);
    }

    public Motion getMotionAfter(Motion motion, TimeSpan span) {
        return new Motion(motion.getSpeed(), this.getBearingAfter(motion.getAngle(), span));
    }
}

