/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import java.io.Serializable;
import java.util.Date;
import org.vesalainen.util.navi.TimeSpan;

public class Period
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Period INFINITE = new Period(new Date(0L), new Date(Long.MAX_VALUE));
    private Date from;
    private Date to;

    protected Period() {
    }

    public Period(Date from, Date to) {
        this.from = from;
        this.to = to;
    }

    public boolean inside(Date date) {
        return !(!this.from.equals(date) && !this.from.before(date) || !this.to.equals(date) && !this.to.after(date));
    }

    public boolean intersect(Period other) {
        return other.inside(this.from) || other.inside(this.to) || this.inside(other.from) || this.inside(other.to);
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    public TimeSpan getTimeSpan() {
        return new TimeSpan(this.to, this.from);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Period other = (Period)obj;
        if (!(this.from == other.from || this.from != null && this.from.equals(other.from))) {
            return false;
        }
        return this.to == other.to || this.to != null && this.to.equals(other.to);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.from != null ? this.from.hashCode() : 0);
        hash = 89 * hash + (this.to != null ? this.to.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.from.toString() + "-" + this.to.toString();
    }
}

