/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import org.vesalainen.util.navi.AngleStats;
import org.vesalainen.util.navi.Degree;
import org.vesalainen.util.navi.Knots;
import org.vesalainen.util.navi.Motion;
import org.vesalainen.util.navi.SimpleStats;

public class MotionStats {
    protected SimpleStats x = new SimpleStats();
    protected SimpleStats y = new SimpleStats();
    protected SimpleStats speed = new SimpleStats();
    protected AngleStats angle = new AngleStats();
    private int count;

    public MotionStats() {
    }

    public MotionStats(MotionStats a) {
        this.x = new SimpleStats(a.x);
        this.y = new SimpleStats(a.y);
    }

    public MotionStats(MotionStats a1, MotionStats a2) {
        this.x = new SimpleStats(a1.x, a2.x);
        this.y = new SimpleStats(a1.y, a2.y);
        this.speed = new SimpleStats(a1.speed, a2.speed);
        this.angle = new AngleStats(a1.angle, a2.angle);
        this.count = a1.count + a2.count;
    }

    public void add(Motion ... motion) {
        for (Motion m : motion) {
            this.add(m);
        }
    }

    public void add(Motion motion) {
        this.x.add(motion.getX());
        this.y.add(motion.getY());
        this.speed.add(motion.getMetersInSecond());
        this.angle.add(motion.getAngle());
        ++this.count;
    }

    public Motion getAverage() {
        return new Motion(this.x.getAverage(), this.y.getAverage());
    }

    public void reset() {
        this.x.clear();
        this.y.clear();
        this.speed.clear();
        this.angle.reset();
        this.count = 0;
    }

    public int getCount() {
        return this.count;
    }

    public double getSpeedDeviation() {
        return this.speed.getDeviation();
    }

    public double getAngleDeviation() {
        return this.angle.getDeviation();
    }

    public String toString() {
        return this.getAverage().toString();
    }

    public static void main(String[] args) {
        try {
            MotionStats aa = new MotionStats();
            aa.add(new Motion(new Knots(6.0), new Degree(350)));
            aa.add(new Motion(new Knots(6.0), new Degree(170)));
            aa.add(new Motion(new Knots(6.0), new Degree(270)));
            System.err.println(aa.getAverage());
            System.err.println(aa.getSpeedDeviation());
            System.err.println(aa.getAngleDeviation());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

