/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import org.vesalainen.util.navi.Angle;
import org.vesalainen.util.navi.Coordinate;
import org.vesalainen.util.navi.Distance;
import org.vesalainen.util.navi.Motion;
import org.vesalainen.util.navi.NauticalMile;
import org.vesalainen.util.navi.RateOfTurn;
import org.vesalainen.util.navi.TimeSpan;
import org.vesalainen.util.navi.Velocity;

public class Location
extends Point2D.Double {
    public static final double PI2 = Math.PI * 2;
    private static final DecimalFormat MINUTEFORMATWITHDECIMAL = new DecimalFormat("00.00");
    private static final DecimalFormat MINYTEFORMATWITHOUTDECIMAL = new DecimalFormat("00");
    private static final DecimalFormat DEGREEFORMAT = new DecimalFormat("000");

    public Location() {
        super(0.0, 0.0);
    }

    public Location(double latitude, double longitude) {
        super(longitude, latitude);
    }

    public Location(Point2D point) {
        super(point.getX(), point.getY());
    }

    public Location(String loc) {
        try {
            boolean latitudeOk = false;
            boolean longitudeOk = false;
            ParsePosition pos = new ParsePosition(0);
            Coordinate coordinate = Coordinate.lookingAt(loc, pos);
            switch (coordinate.getType()) {
                case LATITUDE: {
                    this.y = coordinate.getCoordinate();
                    latitudeOk = true;
                    break;
                }
                case LONGITUDE: {
                    this.x = coordinate.getCoordinate();
                    longitudeOk = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(loc + " cardinal direction unknown");
                }
            }
            coordinate = Coordinate.lookingAt(loc, pos);
            switch (coordinate.getType()) {
                case LATITUDE: {
                    this.y = coordinate.getCoordinate();
                    latitudeOk = true;
                    break;
                }
                case LONGITUDE: {
                    this.x = coordinate.getCoordinate();
                    longitudeOk = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(loc + " cardinal direction unknown");
                }
            }
            if (!latitudeOk || !longitudeOk) {
                throw new IllegalArgumentException(loc + " cardinal direction(s) unknown");
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Location(String latitude, String longitude) {
        try {
            Coordinate coordinate = Coordinate.match(latitude);
            if (!Coordinate.Type.LATITUDE.equals((Object)coordinate.getType())) {
                throw new IllegalArgumentException(latitude);
            }
            this.y = coordinate.getCoordinate();
            coordinate = Coordinate.match(longitude);
            if (!Coordinate.Type.LONGITUDE.equals((Object)coordinate.getType())) {
                throw new IllegalArgumentException(longitude);
            }
            this.x = coordinate.getCoordinate();
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static Location getInstance(String latitude, String longitude) {
        return new Location(latitude, longitude);
    }

    public double getLatitude() {
        return this.y;
    }

    public double getLongitude() {
        return this.x;
    }

    public Location copy() {
        Location loc = new Location(this.y, this.x);
        return loc;
    }

    public Location move(Motion motion, TimeSpan timeSpan) {
        Location loc = this.copy();
        loc.moveIt(motion, timeSpan);
        return loc;
    }

    private void moveIt(Motion motion, TimeSpan timeSpan) {
        this.moveIt(motion.getAngle(), motion.getSpeed(), timeSpan);
    }

    public Location move(Angle bearing, Velocity speed, TimeSpan timeSpan) {
        Location loc = this.copy();
        loc.moveIt(bearing, speed, timeSpan);
        return loc;
    }

    private void moveIt(Angle bearing, Velocity speed, TimeSpan timeSpan) {
        this.moveIt(bearing, speed.getDistance(timeSpan));
    }

    public Location move(Angle bearing, Distance distance) {
        Location loc = this.copy();
        loc.moveIt(bearing, distance);
        return loc;
    }

    private void moveIt(Angle bearing, Distance distance) {
        Location ll = this.copy();
        this.y += bearing.cos() * distance.getMiles() / 60.0;
        double dep = Location.departure(this, ll);
        this.x += bearing.sin() * distance.getMiles() / (60.0 * dep);
    }

    public double departure() {
        return Location.departure(this);
    }

    public static double departure(Location location) {
        return Math.cos(Math.toRadians(location.getLatitude()));
    }

    public static double departure(Location loc1, Location loc2) {
        return Math.cos(Math.toRadians((loc2.getLatitude() + loc1.getLatitude()) / 2.0));
    }

    public Angle bearing(Location loc) {
        return Location.bearing(this, loc);
    }

    public static Angle bearing(Location loc1, Location loc2) {
        double bb;
        double dep = Location.departure(loc1, loc2);
        double aa = dep * (loc2.getLongitude() - loc1.getLongitude());
        double dd = Math.atan2(aa, bb = loc2.getLatitude() - loc1.getLatitude());
        if (dd < 0.0) {
            dd += Math.PI * 2;
        }
        return new Angle(dd);
    }

    public Distance distance(Location loc) {
        return Location.distance(this, loc);
    }

    public static Distance distance(Location loc1, Location loc2) {
        double dep = Location.departure(loc1, loc2);
        return new NauticalMile(60.0 * Math.sqrt(Math.pow(loc1.getLatitude() - loc2.getLatitude(), 2.0) + Math.pow(dep * (loc1.getLongitude() - loc2.getLongitude()), 2.0)));
    }

    public static Location center(Location ... location) {
        double lat = 0.0;
        double lon = 0.0;
        double height = 0.0;
        for (int ii = 0; ii < location.length; ++ii) {
            lat += location[ii].getLatitude();
            lon += location[ii].getLongitude();
        }
        Location loc = new Location(lat / (double)location.length, lon / (double)location.length);
        return loc;
    }

    public String getNMEALongitude() {
        String ss = Location.getNMEAString(this.x);
        return "0" + ss.substring(0, 7);
    }

    public String getNMEALatitude() {
        String ss = Location.getNMEAString(this.y);
        return ss.substring(0, 7);
    }

    public String getLongitudeWE() {
        return Coordinate.getWhere(this.x, Coordinate.Type.LONGITUDE);
    }

    public String getLatitudeNS() {
        return Coordinate.getWhere(this.y, Coordinate.Type.LATITUDE);
    }

    @Override
    public boolean equals(Object ob) {
        if (ob instanceof Location) {
            Location loc = (Location)ob;
            return Math.abs(this.x - loc.x) < 1.0E-7 && Math.abs(this.y - loc.y) < 1.0E-7;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return this.getLatitudeString() + " " + this.getLongitudeString();
    }

    public String latitudeString() {
        return this.getLatitudeString();
    }

    public String longitudeString() {
        return this.getLongitudeString();
    }

    public String getLatitudeString() {
        return Coordinate.toDegMin(this.y, Coordinate.Type.LATITUDE);
    }

    public String getLongitudeString() {
        return Coordinate.toDegMin(this.x, Coordinate.Type.LONGITUDE);
    }

    private static String getNMEAString(double coord) {
        int c1;
        double co = Math.abs(coord);
        double dd = co - (double)(c1 = (int)co);
        double c2 = dd * 60.0;
        String ss = Double.toString(c2);
        int idx = ss.indexOf(46);
        if (idx < 2) {
            ss = "0" + ss;
        }
        while (ss.length() < 8) {
            ss = ss + "0";
        }
        return c1 + ss.substring(0, 8);
    }

    public static final Distance distanceToStartLine(Location current, Location portBuoy, Location starboardBuoy) {
        double dep = Location.departure(portBuoy, starboardBuoy);
        double x0 = current.getLongitude() * dep;
        double y0 = current.getLatitude();
        double x1 = portBuoy.getLongitude() * dep;
        double y1 = portBuoy.getLatitude();
        double x2 = starboardBuoy.getLongitude() * dep;
        double y2 = starboardBuoy.getLatitude();
        double d = ((x2 - x1) * (y1 - y0) - (x1 - x0) * (y2 - y1)) / Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        return new NauticalMile(60.0 * d);
    }

    private static double angleBetween(double a1, double a2) {
        double dd = Location.normalize(a2 - a1);
        if (dd > Math.PI) {
            return Math.PI * 2 - dd;
        }
        return dd;
    }

    private static double reverse(double grad) {
        return Location.normalize(grad + Math.PI);
    }

    private static boolean clockwise(double a1, double a2) {
        double dd = Math.abs(a2 - a1);
        if (dd > Math.PI) {
            return a2 < a1;
        }
        return a2 > a1;
    }

    private static double normalize(double grad) {
        return (Math.PI * 2 + grad) % (Math.PI * 2);
    }

    public Location move(Motion motion, RateOfTurn rateOfTurn, TimeSpan timeSpan) {
        return this.move(motion.getAngle(), motion.getSpeed(), rateOfTurn, timeSpan);
    }

    public Location move(Angle bearing, Velocity velocity, RateOfTurn rateOfTurn, TimeSpan timeSpan) {
        Location loc = this.copy();
        loc.moveIt(bearing, velocity, rateOfTurn, timeSpan);
        return loc;
    }

    private void moveIt(Angle bearing, Velocity velocity, RateOfTurn rateOfTurn, TimeSpan timeSpan) {
        if (rateOfTurn.getValue() == 0.0) {
            this.moveIt(bearing, velocity, timeSpan);
        } else {
            TimeSpan timeForFullCircle = rateOfTurn.getTimeForFullCircle();
            Distance radius = rateOfTurn.getRadius(velocity);
            Angle toCenter = bearing.add(Angle.Right, rateOfTurn.isRight());
            this.moveIt(toCenter, radius);
            Angle straightAngle = toCenter.straightAngle();
            Angle circleAngle = new Angle(Math.PI * 2 * (double)timeSpan.getMillis() / (double)timeForFullCircle.getMillis());
            Angle backToCircle = straightAngle.add(circleAngle, rateOfTurn.isRight());
            this.moveIt(backToCircle, radius);
        }
    }
}

