/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vesalainen.util.ConvertUtility;
import org.vesalainen.util.ConvertUtilityException;

public class CoordinateFormat
extends Format {
    private static final Pattern DIGITS = Pattern.compile("[0-9]+");
    private static final Pattern SIGNED_C = Pattern.compile("[0-9,+\\-]+");
    private static final Pattern SIGNED_P = Pattern.compile("[0-9\\.+\\-]+");
    private static final Pattern LON = Pattern.compile("[WE]");
    private static final Pattern LAT = Pattern.compile("[NS]");
    private static final Pattern SEPARATOR_C = Pattern.compile("[^0-9,NSWE]*");
    private static final Pattern SEPARATOR_P = Pattern.compile("[^0-9\\.NSWE]*");
    private static final Pattern PARSE = Pattern.compile("([D]+)|([d]+)|([M]+)|([m]+)|([S]+)|([s]+)|([N])|([E])");
    private CharSequence originalPattern;
    private Pattern[] patterns;
    private Field[] fields;
    private Integer[] precisions;
    private Locale locale;
    private String format;
    private ParseException exception;
    private boolean latitude;
    private char decimalSeparator;

    public boolean isLatitude() {
        return this.latitude;
    }

    public CoordinateFormat(CharSequence pattern) {
        this.locale = Locale.getDefault();
        this.init(pattern);
    }

    public CoordinateFormat(Locale locale, CharSequence pattern) {
        this.locale = locale;
        this.init(pattern);
    }

    private void init(CharSequence pattern) {
        this.originalPattern = pattern;
        DecimalFormatSymbols cfs = new DecimalFormatSymbols(this.locale);
        this.decimalSeparator = cfs.getDecimalSeparator();
        boolean latlonset = false;
        ArrayList<Pattern> pts = new ArrayList<Pattern>();
        ArrayList<Field> tps = new ArrayList<Field>();
        ArrayList<Integer> ps = new ArrayList<Integer>();
        Matcher m = PARSE.matcher(pattern);
        StringBuffer sb = new StringBuffer();
        int last = 0;
        pts.add(this.separator());
        block10: while (m.find()) {
            if (m.start() != last) {
                pts.add(this.separator());
            }
            last = m.end();
            String s = m.group();
            char cc = s.charAt(0);
            switch (cc) {
                case 'E': {
                    pts.add(LON);
                    tps.add(Field.LONGITUDE);
                    ps.add(0);
                    m.appendReplacement(sb, "%s");
                    this.latitude = false;
                    latlonset = true;
                    continue block10;
                }
                case 'N': {
                    pts.add(LAT);
                    tps.add(Field.LATITUDE);
                    ps.add(0);
                    m.appendReplacement(sb, "%s");
                    this.latitude = true;
                    latlonset = true;
                    continue block10;
                }
                case 'D': {
                    pts.add(DIGITS);
                    tps.add(Field.DEGREE);
                    ps.add(0);
                    m.appendReplacement(sb, String.format("%%0%dd", s.length()));
                    continue block10;
                }
                case 'd': {
                    pts.add(this.signed());
                    tps.add(Field.degree);
                    ps.add(Math.max(0, s.length() - 3));
                    m.appendReplacement(sb, String.format("%%0%d.%df", Math.min(1, s.length()), Math.max(0, s.length() - 3)));
                    continue block10;
                }
                case 'M': {
                    pts.add(DIGITS);
                    tps.add(Field.MINUTE);
                    ps.add(0);
                    m.appendReplacement(sb, String.format("%%0%dd", s.length()));
                    continue block10;
                }
                case 'S': {
                    pts.add(DIGITS);
                    tps.add(Field.SECOND);
                    ps.add(0);
                    m.appendReplacement(sb, String.format("%%0%dd", s.length()));
                    continue block10;
                }
                case 's': {
                    pts.add(this.signed());
                    tps.add(Field.second);
                    ps.add(Math.max(0, s.length() - 3));
                    m.appendReplacement(sb, String.format("%%0%d.%df", Math.min(1, s.length()), Math.max(0, s.length() - 3)));
                    continue block10;
                }
                case 'm': {
                    pts.add(this.signed());
                    tps.add(Field.minute);
                    ps.add(Math.max(0, s.length() - 3));
                    m.appendReplacement(sb, String.format("%%0%d.%df", Math.min(1, s.length()), Math.max(0, s.length() - 3)));
                    continue block10;
                }
            }
            throw new UnsupportedOperationException("Unexpected token " + s);
        }
        if (!latlonset) {
            throw new IllegalArgumentException("N/E not set");
        }
        if (last < pattern.length()) {
            pts.add(this.separator());
        }
        m.appendTail(sb);
        this.patterns = pts.toArray(new Pattern[pts.size()]);
        this.fields = tps.toArray(new Field[tps.size()]);
        this.precisions = ps.toArray(new Integer[ps.size()]);
        this.format = sb.toString();
    }

    public Pattern signed() {
        if (this.decimalSeparator == '.') {
            return SIGNED_P;
        }
        return SIGNED_C;
    }

    public Pattern separator() {
        if (this.decimalSeparator == '.') {
            return SEPARATOR_P;
        }
        return SEPARATOR_C;
    }

    public String format(double coordinate) {
        StringBuffer sb = new StringBuffer();
        FieldPosition pos = new FieldPosition(0);
        this.format(coordinate, sb, pos);
        return sb.toString();
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        try {
            Double dd = ConvertUtility.convert(Double.class, obj);
            double c1 = Math.abs(dd);
            double c2 = 60.0 * (c1 - Math.floor(c1));
            double c3 = 60.0 * (c2 - Math.floor(c2));
            Object[] args = new Object[this.fields.length];
            block12: for (int ii = 0; ii < this.fields.length; ++ii) {
                switch (this.fields[ii]) {
                    case DEGREE: {
                        args[ii] = new Integer((int)Math.floor(c1));
                        continue block12;
                    }
                    case degree: {
                        args[ii] = this.trunc(dd, this.precisions[ii]);
                        continue block12;
                    }
                    case MINUTE: {
                        args[ii] = new Integer((int)Math.floor(c2));
                        continue block12;
                    }
                    case minute: {
                        args[ii] = this.trunc(c2, this.precisions[ii]);
                        continue block12;
                    }
                    case SECOND: {
                        args[ii] = new Integer((int)c3);
                        continue block12;
                    }
                    case second: {
                        args[ii] = this.trunc(c3, this.precisions[ii]);
                        continue block12;
                    }
                    case LATITUDE: {
                        if (dd > 0.0) {
                            args[ii] = "N";
                            continue block12;
                        }
                        args[ii] = "S";
                        continue block12;
                    }
                    case LONGITUDE: {
                        args[ii] = dd > 0.0 ? "E" : "W";
                    }
                }
            }
            String res = String.format(this.locale, this.format, args);
            toAppendTo.append(res);
            return toAppendTo;
        }
        catch (ConvertUtilityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private double trunc(double d, int precision) {
        double p = Math.pow(10.0, precision);
        return Math.floor(d * p) / p;
    }

    public double parseDouble(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Double dd = (Double)this.parseObject(source, pos);
        if (dd == null) {
            throw this.exception;
        }
        return dd;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        NumberFormat nf = NumberFormat.getNumberInstance(this.locale);
        Boolean lat = null;
        double degree = 0.0;
        double minute = 0.0;
        double second = 0.0;
        double sign = 1.0;
        int index = 0;
        int safe = pos.getIndex();
        try {
            block13: for (Pattern pattern : this.patterns) {
                Matcher mm = pattern.matcher(source);
                mm.region(pos.getIndex(), source.length());
                if (!mm.lookingAt()) {
                    pos.setErrorIndex(pos.getIndex());
                    pos.setIndex(safe);
                    this.exception = new ParseException(pattern.toString(), pos.getErrorIndex());
                    return null;
                }
                pos.setIndex(mm.end());
                if (SEPARATOR_P.equals(pattern) || SEPARATOR_C.equals(pattern)) continue;
                Field field = this.fields[index++];
                switch (field) {
                    case DEGREE: {
                        degree = Integer.parseInt(mm.group());
                        if (!(degree < 0.0) && !(degree > 180.0)) continue block13;
                        pos.setErrorIndex(pos.getIndex());
                        pos.setIndex(safe);
                        this.exception = new ParseException("Degree not in range " + degree, pos.getErrorIndex());
                        return null;
                    }
                    case degree: {
                        degree = nf.parse(mm.group()).doubleValue();
                        if (!(degree < 0.0) && !(degree > 180.0)) continue block13;
                        pos.setErrorIndex(pos.getIndex());
                        pos.setIndex(safe);
                        this.exception = new ParseException("Degree not in range " + degree, pos.getErrorIndex());
                        return null;
                    }
                    case MINUTE: {
                        minute = Integer.parseInt(mm.group());
                        if (!(minute < 0.0) && !(minute > 60.0)) continue block13;
                        pos.setErrorIndex(pos.getIndex());
                        pos.setIndex(safe);
                        this.exception = new ParseException("Minute not in range " + minute, pos.getErrorIndex());
                        return null;
                    }
                    case minute: {
                        minute = nf.parse(mm.group()).doubleValue();
                        if (!(minute < 0.0) && !(minute > 60.0)) continue block13;
                        pos.setErrorIndex(pos.getIndex());
                        pos.setIndex(safe);
                        this.exception = new ParseException("Minute not in range " + minute, pos.getErrorIndex());
                        return null;
                    }
                    case SECOND: {
                        second = Integer.parseInt(mm.group());
                        if (!(second < 0.0) && !(second > 60.0)) continue block13;
                        pos.setErrorIndex(pos.getIndex());
                        pos.setIndex(safe);
                        this.exception = new ParseException("Second not in range " + second, pos.getErrorIndex());
                        return null;
                    }
                    case second: {
                        second = nf.parse(mm.group()).doubleValue();
                        if (!(second < 0.0) && !(second > 60.0)) continue block13;
                        pos.setErrorIndex(pos.getIndex());
                        pos.setIndex(safe);
                        this.exception = new ParseException("Second not in range " + second, pos.getErrorIndex());
                        return null;
                    }
                    case LATITUDE: {
                        lat = true;
                        if (!"S".equals(mm.group())) continue block13;
                        sign = -1.0;
                        continue block13;
                    }
                    case LONGITUDE: {
                        lat = false;
                        if (!"W".equals(mm.group())) continue block13;
                        sign = -1.0;
                    }
                }
            }
        }
        catch (ParseException ex) {
            pos.setErrorIndex(pos.getIndex());
            pos.setIndex(safe);
            this.exception = ex;
            return null;
        }
        catch (NumberFormatException ex) {
            pos.setErrorIndex(pos.getIndex());
            pos.setIndex(safe);
            this.exception = new ParseException(ex.getMessage(), pos.getErrorIndex());
            return null;
        }
        double res = sign * (degree + minute / 60.0 + second / 3600.0);
        if (lat != null && lat.booleanValue()) {
            if (Math.abs(res) > 90.0) {
                pos.setErrorIndex(pos.getIndex());
                pos.setIndex(safe);
                this.exception = new ParseException("Latitude not in range " + res, pos.getErrorIndex());
                return null;
            }
        } else if (Math.abs(res) > 180.0) {
            pos.setErrorIndex(pos.getIndex());
            pos.setIndex(safe);
            this.exception = new ParseException("Longitude not in range " + res, pos.getErrorIndex());
            return null;
        }
        return new Double(res);
    }

    public String toString() {
        return this.originalPattern.toString();
    }

    public static void main(String ... args) {
        try {
            CoordinateFormat cf = new CoordinateFormat(Locale.US, "DDD,mmmmmN");
            System.err.println(cf.parseObject(cf.format(0.99999999999999)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static enum Field {
        DEGREE,
        degree,
        MINUTE,
        minute,
        SECOND,
        second,
        LONGITUDE,
        LATITUDE;

    }
}

