/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Random;
import org.vesalainen.util.navi.CoordinateFormat;

public class Coordinate {
    private static final String DEGREE = "\u00b0";
    private static final CoordinateFormat DEGMINSECFORMATLAT = new CoordinateFormat(Locale.US, "DD\u00b0MM'ssss\"N");
    private static final CoordinateFormat DEGMINSECFORMATLON = new CoordinateFormat(Locale.US, "DDD\u00b0MM'ssss\"E");
    private static final CoordinateFormat DEGMINFORMATLAT = new CoordinateFormat(Locale.US, "DD\u00b0mmmmm'N");
    private static final CoordinateFormat DEGMINFORMATLON = new CoordinateFormat(Locale.US, "DDD\u00b0mmmmm'E");
    private static final CoordinateFormat DEGFORMATLAT = new CoordinateFormat(Locale.US, "ddddd\u00b0N");
    private static final CoordinateFormat DEGFORMATLON = new CoordinateFormat(Locale.US, "dddddd\u00b0E");
    private static final CoordinateFormat[] FORMATS = new CoordinateFormat[]{DEGFORMATLAT, DEGFORMATLON, DEGMINFORMATLAT, DEGMINFORMATLON, DEGMINSECFORMATLAT, DEGMINSECFORMATLON};
    private double _coordinate;
    private Type _type;

    public Coordinate(double coordinate, Type type) {
        this._coordinate = coordinate;
        this._type = type;
    }

    protected Coordinate(double coordinate, Direction direction) {
        if (coordinate < 0.0) {
            throw new IllegalArgumentException(String.valueOf(coordinate));
        }
        switch (direction) {
            case N: {
                this._coordinate = coordinate;
                this._type = Type.LATITUDE;
                break;
            }
            case S: {
                this._coordinate = -coordinate;
                this._type = Type.LATITUDE;
                break;
            }
            case W: {
                this._coordinate = -coordinate;
                this._type = Type.LONGITUDE;
                break;
            }
            case E: {
                this._coordinate = coordinate;
                this._type = Type.LONGITUDE;
            }
        }
    }

    public Coordinate(String str) {
        Coordinate coordinate = Coordinate.match(str);
        this._coordinate = coordinate.getCoordinate();
        this._type = coordinate.getType();
    }

    public static final Coordinate match(String str) {
        for (CoordinateFormat fmt : FORMATS) {
            try {
                double dd = fmt.parseDouble(str);
                if (fmt.isLatitude()) {
                    return new Coordinate(dd, Type.LATITUDE);
                }
                return new Coordinate(dd, Type.LONGITUDE);
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException(str);
    }

    public static final Coordinate lookingAt(String str, ParsePosition idx) {
        for (CoordinateFormat fmt : FORMATS) {
            ParsePosition pos = new ParsePosition(idx.getIndex());
            Double dd = (Double)fmt.parseObject(str, pos);
            if (dd == null) continue;
            idx.setIndex(pos.getIndex());
            if (fmt.isLatitude()) {
                return new Coordinate((double)dd, Type.LATITUDE);
            }
            return new Coordinate((double)dd, Type.LONGITUDE);
        }
        throw new IllegalArgumentException(str);
    }

    public double getCoordinate() {
        return this._coordinate;
    }

    public Type getType() {
        return this._type;
    }

    public String toString() {
        return this.toDegMin();
    }

    public String toDeg() {
        return Coordinate.toDeg(this._coordinate, this._type);
    }

    public String toDegMin() {
        return Coordinate.toDegMin(this._coordinate, this._type);
    }

    public String toDegMinSec() {
        return Coordinate.toDegMinSec(this._coordinate, this._type);
    }

    public String getWhere() {
        return Coordinate.getWhere(this._coordinate, this._type);
    }

    public static String toDeg(double coordinate, Type type) {
        switch (type) {
            case LATITUDE: {
                return DEGMINFORMATLAT.format(coordinate);
            }
            case LONGITUDE: {
                return DEGMINFORMATLON.format(coordinate);
            }
        }
        throw new UnsupportedOperationException("Unknown type");
    }

    public static String toDegMin(double coordinate, Type type) {
        switch (type) {
            case LATITUDE: {
                return DEGMINFORMATLAT.format(coordinate);
            }
            case LONGITUDE: {
                return DEGMINFORMATLON.format(coordinate);
            }
        }
        throw new UnsupportedOperationException("Unknown type");
    }

    public static String toDegMinSec(double coordinate, Type type) {
        switch (type) {
            case LATITUDE: {
                return DEGMINSECFORMATLAT.format(coordinate);
            }
            case LONGITUDE: {
                return DEGMINSECFORMATLON.format(coordinate);
            }
        }
        throw new UnsupportedOperationException("Unknown type");
    }

    public static String getWhere(double coordinate, Type type) {
        switch (type) {
            case LATITUDE: {
                if (coordinate >= 0.0) {
                    return "N";
                }
                return "S";
            }
            case LONGITUDE: {
                if (coordinate >= 0.0) {
                    return "E";
                }
                return "W";
            }
        }
        return "?";
    }

    public boolean equals(Object oth) {
        if (oth instanceof Coordinate) {
            Coordinate coordinate = (Coordinate)oth;
            return this.getType().equals((Object)coordinate.getType()) && Math.abs(this._coordinate - coordinate._coordinate) < 1.0E-4;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (int)(Double.doubleToLongBits(this._coordinate) ^ Double.doubleToLongBits(this._coordinate) >>> 32);
        hash = 47 * hash + this._type.hashCode();
        return hash;
    }

    public static void main(String[] args) {
        try {
            Random rand = new Random();
            for (int ii = 0; ii < 1000; ++ii) {
                double coordinate;
                Coordinate c1 = null;
                if (rand.nextBoolean()) {
                    coordinate = 180.0 * rand.nextDouble() - 90.0;
                    c1 = new Coordinate(coordinate, Type.LATITUDE);
                } else {
                    coordinate = 360.0 * rand.nextDouble() - 180.0;
                    c1 = new Coordinate(coordinate, Type.LONGITUDE);
                }
                Coordinate c2 = new Coordinate(c1.toDeg());
                Coordinate c3 = new Coordinate(c1.toDegMin());
                Coordinate c4 = new Coordinate(c1.toDegMinSec());
                Coordinate.check(c1, c2);
                Coordinate.check(c1, c3);
                Coordinate.check(c1, c4);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void check(Coordinate c1, Coordinate c2) {
        if (!c1.equals(c2)) {
            double diff = c1.getCoordinate() - c2.getCoordinate();
            System.err.println(c1 + " <> " + c2 + " " + diff);
        }
    }

    public static enum Direction {
        N,
        S,
        W,
        E;

    }

    public static enum Type {
        LATITUDE,
        LONGITUDE,
        UNKNOWN;

    }
}

