/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.navi;

import org.vesalainen.util.navi.Angle;
import org.vesalainen.util.navi.Degree;
import org.vesalainen.util.navi.SimpleStats;

public class AngleStats {
    private SimpleStats sin = new SimpleStats();
    private SimpleStats cos = new SimpleStats();
    private SimpleStats angleRange = new SimpleStats();
    private double deviationSquare;
    private int count;

    public AngleStats() {
    }

    public AngleStats(AngleStats a) {
        this.sin = new SimpleStats(a.sin);
        this.cos = new SimpleStats(a.cos);
    }

    public AngleStats(AngleStats a1, AngleStats a2) {
        this.sin = new SimpleStats(a1.sin, a2.sin);
        this.cos = new SimpleStats(a1.cos, a2.cos);
        this.angleRange = new SimpleStats(a1.angleRange, a2.angleRange);
        this.count = a1.count + a2.count;
        this.deviationSquare = ((double)a1.count * a1.deviationSquare + (double)a2.count * a2.deviationSquare) / (double)this.count;
    }

    public void add(Angle ... angles) {
        for (Angle angle : angles) {
            this.add(angle);
        }
    }

    public void add(Angle angle) {
        this.sin.add(angle.sin());
        this.cos.add(angle.cos());
        this.angleRange.add(angle.getRadians());
        this.deviationSquare = (double)this.count * this.deviationSquare / (double)(this.count + 1) + Math.pow(Angle.angleDiff(angle.getRadians(), this.getAverage().getRadians()), 2.0) / (double)(this.count + 1);
        ++this.count;
    }

    public Angle getAverage() {
        return new Angle(this.cos.getAverage(), this.sin.getAverage());
    }

    public Angle getRange() {
        return new Angle(this.angleRange.getRange());
    }

    public Angle getMax() {
        return new Angle(this.angleRange.getMax());
    }

    public Angle getMin() {
        return new Angle(this.angleRange.getMin());
    }

    public double getDeviation() {
        return Math.sqrt(this.deviationSquare);
    }

    public void reset() {
        this.sin.clear();
        this.cos.clear();
        this.count = 0;
        this.deviationSquare = 0.0;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return this.getAverage().toString();
    }

    public static void main(String[] args) {
        try {
            AngleStats aa = new AngleStats();
            Degree a1 = new Degree(1);
            Degree a2 = new Degree(2);
            Degree a3 = new Degree(3);
            for (int ii = 0; ii < 100; ++ii) {
                aa.add(a1, a2, a3);
                System.err.println(aa.getDeviation() + " " + aa.getAverage());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

