/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.logging;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.vesalainen.util.logging.BaseLogging;

public class JavaLogging
extends BaseLogging {
    private Logger logger;

    public JavaLogging() {
    }

    public JavaLogging(Class<?> cls) {
        this.setLogger(cls);
    }

    public JavaLogging(Class<?> cls, String ext) {
        this.setLogger(cls, ext);
    }

    public JavaLogging(String name) {
        this.setLogger(name);
    }

    public JavaLogging(String name, String ext) {
        this.setLogger(name, ext);
    }

    public JavaLogging(Logger logger) {
        this.setLogger(logger);
    }

    public final void setLogger(Logger logger) {
        this.logger = logger;
    }

    public final void setLogger(Class<?> cls) {
        this.setLogger(cls.getName().replace('$', '.'));
    }

    public final void setLogger(Class<?> cls, String ext) {
        this.setLogger(cls.getName().replace('$', '.'), ext);
    }

    public final void setLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    public final void setLogger(String name, String ext) {
        this.logger = Logger.getLogger(name + '.' + ext);
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    @Override
    protected void logIt(Level level, String msg) {
        this.logger.log(level, msg);
    }

    @Override
    protected void logIt(Level level, String msg, Throwable thrown) {
        this.logger.log(level, msg, thrown);
    }

    @Override
    public List<String> getLoggerNames() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<String> cl = LogManager.getLogManager().getLoggerNames();
        while (cl.hasMoreElements()) {
            list.add(cl.nextElement().toString());
        }
        return list;
    }
}

