/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.logging;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.vesalainen.util.logging.MinimalFormatter;

public class ChannelHandler
extends Handler {
    private final ByteBuffer bb = ByteBuffer.allocateDirect(4096);
    private final WritableByteChannel channel;
    private final ReentrantLock lock = new ReentrantLock();

    public ChannelHandler(WritableByteChannel channel) {
        this.channel = channel;
        this.setFormatter(new MinimalFormatter());
    }

    @Override
    public void publish(LogRecord record) {
        this.lock.lock();
        try {
            Formatter formatter = this.getFormatter();
            this.bb.clear();
            this.bb.put(formatter.format(record).getBytes());
            this.bb.flip();
            this.channel.write(this.bb);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

