/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.fi;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class WorkingCalendar
extends GregorianCalendar {
    public static final int WORK = 0;
    public static final int SAT = 1;
    public static final int HOLY = 2;

    public WorkingCalendar(int year, int month, int day) {
        super(year, month, day);
    }

    public int isWorkDay() {
        if (this.get(7) == 1) {
            return 2;
        }
        if (this.get(2) == 0 && this.get(5) == 1) {
            return 2;
        }
        if (this.get(2) == 0 && this.get(5) == 6) {
            return 2;
        }
        if (this.get(2) == 4 && this.get(5) == 1) {
            return 2;
        }
        if (this.get(2) == 5 && this.get(7) == 6 && this.get(5) <= 25 && this.get(5) > 18) {
            return 2;
        }
        if (this.get(2) == 11 && this.get(5) == 6) {
            return 2;
        }
        if (this.get(2) == 11 && this.get(5) == 24) {
            return 2;
        }
        if (this.get(2) == 11 && this.get(5) == 25) {
            return 2;
        }
        if (this.get(2) == 11 && this.get(5) == 26) {
            return 2;
        }
        if (this.isEaster(this)) {
            return 2;
        }
        this.add(5, 2);
        if (this.isEaster(this)) {
            this.add(5, -2);
            return 2;
        }
        this.add(5, -2);
        this.add(5, -1);
        if (this.isEaster(this)) {
            this.add(5, 1);
            return 2;
        }
        this.add(5, 1);
        this.add(5, -39);
        if (this.isEaster(this)) {
            this.add(5, 39);
            return 2;
        }
        this.add(5, 39);
        if (this.get(7) == 7) {
            return 1;
        }
        return 0;
    }

    public boolean isEaster(Calendar cal) {
        int Y = cal.get(1);
        int C = Y / 100;
        int N = Y - 19 * (Y / 19);
        int K = (C - 17) / 25;
        int I = C - C / 4 - (C - K) / 3 + 19 * N + 15;
        I -= 30 * (I / 30);
        I -= I / 28 * (1 - I / 28 * (29 / (I + 1)) * ((21 - N) / 11));
        int J = Y + Y / 4 + I + 2 - C + C / 4;
        J -= 7 * (J / 7);
        int L = I - J;
        int M = 3 + (L + 40) / 44;
        int D = L + 28 - 31 * (M / 4);
        return M == cal.get(2) + 1 && D == cal.get(5);
    }

    public static void main(String[] args) {
        try {
            WorkingCalendar cal = new WorkingCalendar(2001, 0, 1);
            for (int ii = 0; ii < 365; ++ii) {
                cal.isWorkDay();
                cal.add(5, 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

