/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.vesalainen.util.concurrent.ThreadStoppedException;

public abstract class SimpleWorkflow<K, M, C> {
    private final Map<K, Thread> threadMap;
    private final Map<Thread, Semaphore> semaphoreMap;
    private final Semaphore stopSemaphore;
    private final int maxParallelism;
    private final long timeout;
    private final TimeUnit timeUnit;
    private final ReentrantLock lock = new ReentrantLock();
    private ReentrantLock contextLock;
    private C context;
    private final Map<K, M> messageMap = Collections.synchronizedMap(new HashMap());
    private final Set<K> parallelSet = Collections.synchronizedSet(new HashSet());

    public SimpleWorkflow(K start) {
        this(start, null, 1, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public SimpleWorkflow(K start, C context) {
        this(start, context, 1, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public SimpleWorkflow(K start, C context, int maxParallelism, long timeout, TimeUnit timeUnit) {
        if (maxParallelism < 0) {
            throw new IllegalArgumentException("maxParallelism < 0");
        }
        this.context = context;
        this.maxParallelism = maxParallelism;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.stopSemaphore = new Semaphore(maxParallelism);
        this.semaphoreMap = new HashMap<Thread, Semaphore>();
        this.threadMap = new HashMap<K, Thread>();
        this.contextLock = new ReentrantLock();
        Thread currentThread = Thread.currentThread();
        this.threadMap.put(start, currentThread);
        this.semaphoreMap.put(currentThread, new Semaphore(0));
    }

    public void fork(K to) {
        this.fork(to, null);
    }

    public void fork(K to, M msg) {
        if (this.maxParallelism == 0) {
            throw new IllegalArgumentException("maxParallelism == 0, fork() not allowed! Use switchTo.");
        }
        try {
            this.stopSemaphore.acquire();
            this.parallelSet.add(this.getCurrentKey());
            this.doFork(to, msg);
        }
        catch (InterruptedException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFork(K to, M msg) {
        this.lock.lock();
        try {
            if (this.threadMap.isEmpty()) {
                throw new IllegalStateException("threads are already interrupted");
            }
            this.messageMap.put(to, msg);
            Thread nextThread = this.threadMap.get(to);
            if (nextThread == null) {
                Runnable runnable = this.create(to);
                runnable = new Wrapper(runnable);
                nextThread = new Thread(runnable, to.toString());
                Semaphore semaphore = new Semaphore(0);
                this.threadMap.put(to, nextThread);
                this.semaphoreMap.put(nextThread, semaphore);
                nextThread.start();
            } else {
                Semaphore semaphore = this.semaphoreMap.get(nextThread);
                semaphore.release();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public M join() {
        if (this.threadMap.isEmpty()) {
            throw new IllegalStateException("threads are already interrupted");
        }
        Thread currentThread = Thread.currentThread();
        Semaphore currentSemaphore = this.semaphoreMap.get(currentThread);
        if (currentSemaphore == null) {
            throw new IllegalStateException("Current thread is not workflow thread");
        }
        this.stopSemaphore.release();
        this.parallelSet.remove(this.getCurrentKey());
        return this.doJoin();
    }

    private M doJoin() {
        try {
            Thread currentThread = Thread.currentThread();
            Semaphore currentSemaphore = this.semaphoreMap.get(currentThread);
            if (currentSemaphore == null) {
                throw new ThreadStoppedException("stopped");
            }
            boolean success = currentSemaphore.tryAcquire(this.timeout, this.timeUnit);
            if (!success) {
                this.lock.lock();
                try {
                    this.semaphoreMap.remove(currentThread);
                    Iterator<Map.Entry<K, Thread>> it = this.threadMap.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<K, Thread> entry = it.next();
                        if (!currentThread.equals(entry.getValue())) continue;
                        it.remove();
                        break;
                    }
                    throw new ThreadStoppedException("timeout");
                }
                catch (Throwable throwable) {
                    this.lock.unlock();
                    throw throwable;
                }
            }
            return this.getMessage();
        }
        catch (InterruptedException ex) {
            throw new ThreadStoppedException(ex);
        }
    }

    public M getMessage() {
        return this.messageMap.get(this.getCurrentKey());
    }

    public M switchTo(K to) {
        return this.switchTo(to, null);
    }

    public M switchTo(K to, M msg) {
        this.doFork(to, msg);
        return this.doJoin();
    }

    public int getThreadCount() {
        if (this.threadMap.isEmpty()) {
            throw new IllegalStateException("threads are already interrupted");
        }
        return this.threadMap.size();
    }

    public void endTo(K to) {
        this.endTo(to, null);
    }

    public void endTo(K to, M msg) {
        K key = this.getCurrentKey();
        if (key.equals(to)) {
            throw new IllegalArgumentException("current and to are equals");
        }
        if (key != null) {
            this.kill(key);
            this.doFork(to, msg);
            throw new ThreadStoppedException("suicide");
        }
        throw new IllegalArgumentException("called from wrong thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K getCurrentKey() {
        this.lock.lock();
        try {
            Thread currentThread = Thread.currentThread();
            for (Map.Entry<K, Thread> entry : this.threadMap.entrySet()) {
                if (!currentThread.equals(entry.getValue())) continue;
                K k = entry.getKey();
                return k;
            }
            Iterator<Map.Entry<K, Thread>> iterator = null;
            return (K)iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void kill(K key) {
        if (this.threadMap.isEmpty()) {
            throw new IllegalStateException("threads are already interrupted");
        }
        this.lock.lock();
        try {
            Thread thread = this.threadMap.get(key);
            this.threadMap.remove(key);
            this.semaphoreMap.remove(thread);
            if (this.parallelSet.contains(key)) {
                this.parallelSet.remove(key);
                this.stopSemaphore.release();
            }
            thread.interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void waitAndStopThreads() {
        try {
            if (this.threadMap.isEmpty()) {
                throw new IllegalStateException("threads are already interrupted");
            }
            this.stopSemaphore.acquire(this.maxParallelism);
            this.stopThreads();
        }
        catch (InterruptedException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThreads() {
        if (this.threadMap.isEmpty()) {
            throw new IllegalStateException("threads are already interrupted");
        }
        this.lock.lock();
        try {
            Thread currentThread = Thread.currentThread();
            for (Thread thread : this.threadMap.values()) {
                if (currentThread.equals(thread)) continue;
                thread.interrupt();
            }
            this.threadMap.clear();
            this.semaphoreMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract Runnable create(K var1);

    public <R> R accessContext(ContextAccess<C, R> access) {
        this.contextLock.lock();
        try {
            R r = access.access(this.context);
            return r;
        }
        finally {
            this.contextLock.unlock();
        }
    }

    public static interface ContextAccess<C, R> {
        public R access(C var1);
    }

    public class Wrapper
    implements Runnable {
        private Runnable runner;

        public Wrapper(Runnable runner) {
            this.runner = runner;
        }

        @Override
        public void run() {
            try {
                this.runner.run();
            }
            catch (Throwable oex) {
                for (Throwable ex = oex; ex != null; ex = ex.getCause()) {
                    if (!(ex instanceof ThreadStoppedException)) continue;
                    return;
                }
                throw oex;
            }
        }
    }
}

