/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.concurrent;

public class RingSpan {
    private int modulo;
    private int start;
    private int end;

    public RingSpan(int modulo) {
        if (modulo <= 1) {
            throw new IllegalArgumentException("illegal modulo " + modulo);
        }
        this.modulo = modulo;
    }

    public void addStart(int count) {
        if (count > this.length()) {
            throw new IllegalArgumentException("illegal count " + count);
        }
        this.start += count;
    }

    public int increment() {
        return this.increment(1);
    }

    public int increment(int count) {
        if (count < 0 || count > this.modulo) {
            throw new IllegalArgumentException("illegal count " + count);
        }
        if (this.length() > this.modulo - count) {
            throw new IllegalArgumentException("buffer underflow");
        }
        this.end += count;
        return this.end % this.modulo;
    }

    public int length() {
        return this.end - this.start;
    }

    public int length(RingSpan oth) {
        return oth.start - this.start;
    }

    public void clear() {
        this.start = this.end;
    }

    public int start() {
        return this.start % this.modulo;
    }

    public int end() {
        return this.end % this.modulo;
    }
}

