/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.concurrent;

import java.nio.ByteBuffer;
import java.util.concurrent.Semaphore;
import org.vesalainen.util.concurrent.RingSpan;
import org.vesalainen.util.concurrent.RingbufferSupport;
import org.vesalainen.util.concurrent.SynchronizedRingBuffer;

public abstract class BufferConsumer
implements Runnable {
    private SynchronizedRingBuffer ring;
    private RingbufferSupport bs;
    private RingSpan span;
    private final Semaphore semaphore = new Semaphore(0);

    protected byte read() throws InterruptedException {
        this.semaphore.acquire();
        return this.bs.get(this.span.increment());
    }

    protected void release() {
        this.span.clear();
        this.ring.release();
    }

    RingSpan position() {
        return this.span;
    }

    public ByteBuffer[] getInput() {
        return this.bs.getBuffersForSpan(this.span);
    }

    void setRing(SynchronizedRingBuffer ring) {
        if (this.ring != null) {
            throw new IllegalStateException("attached already");
        }
        this.ring = ring;
        ByteBuffer buffer = ring.getBuffer();
        this.bs = new RingbufferSupport(buffer);
        this.span = new RingSpan(buffer.capacity());
    }

    protected abstract void consume();

    @Override
    public void run() {
        this.consume();
    }

    void input(int rc) {
        this.semaphore.release(rc);
    }
}

