/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util.code128;

import org.vesalainen.util.code128.Code128Constants;

public class Code128
extends Code128Constants {
    private char[] mybars = null;

    public Code128(String text) {
        String encoded = null;
        this.mybars = Code128.encode(text);
        encoded = Code128.decode(this.mybars);
        if (!text.equals(encoded)) {
            throw new IllegalArgumentException("'" + text + "' <> '" + encoded + "'");
        }
    }

    public char[] getBars() {
        return this.mybars;
    }

    public static char[] encode(String txt) {
        int codeset;
        int inidx = 0;
        char[] bars = null;
        int iBars = 0;
        StringBuffer sb = new StringBuffer();
        StringBuffer text = new StringBuffer(txt);
        if (Code128.countDigits(text) >= 4) {
            codeset = 2;
            sb.append('i');
        } else if (Code128.ctrlBeforeLower(text)) {
            codeset = 0;
            sb.append('g');
        } else {
            codeset = 1;
            sb.append('h');
        }
        if (codeset == 2 && (inidx = Code128.packDigits(sb, text)) < text.length() && Code128.isdigit(text.charAt(inidx))) {
            if (Code128.ctrlBeforeLower(text.substring(inidx))) {
                sb.append(tabFunc[5][codeset]);
                codeset = 0;
            } else {
                sb.append(tabFunc[6][codeset]);
                codeset = 1;
            }
        }
        while (inidx < text.length()) {
            int digits;
            if (text.charAt(inidx) > '\u007f') {
                sb.append(tabFunc[3][codeset]);
                text.setCharAt(inidx, (char)(text.charAt(inidx) - 128));
            }
            if ((codeset == 0 || codeset == 1) && (digits = Code128.countDigits(text.substring(inidx))) >= 4) {
                if (Code128.even(digits)) {
                    sb.append(tabFunc[7][codeset]);
                    codeset = 2;
                } else {
                    sb.append(Code128.codeIn(text.charAt(inidx++), codeset));
                    sb.append(tabFunc[7][codeset]);
                    codeset = 2;
                }
            }
            if (codeset == 1) {
                if (Code128.control(text.charAt(inidx))) {
                    if (Code128.lower(text.charAt(inidx + 1))) {
                        sb.append(tabFunc[4][codeset]);
                        sb.append(Code128.codeIn(text.charAt(inidx++), 0));
                    } else {
                        sb.append(tabFunc[5][codeset]);
                        codeset = 0;
                        sb.append(Code128.codeIn(text.charAt(inidx++), codeset));
                    }
                } else {
                    sb.append(Code128.codeIn(text.charAt(inidx++), codeset));
                }
            }
            if (codeset == 0) {
                if (Code128.lower(text.charAt(inidx))) {
                    if (Code128.control(text.charAt(inidx + 1))) {
                        sb.append(tabFunc[4][codeset]);
                        sb.append(Code128.codeIn(text.charAt(inidx++), 1));
                    } else {
                        sb.append(tabFunc[6][codeset]);
                        codeset = 1;
                        sb.append(Code128.codeIn(text.charAt(inidx++), codeset));
                    }
                } else {
                    sb.append(Code128.codeIn(text.charAt(inidx++), codeset));
                }
            }
            if (codeset != 2) continue;
            if (!Code128.isdigit(text.charAt(inidx))) {
                if (Code128.ctrlBeforeLower(text.substring(inidx))) {
                    sb.append(tabFunc[5][codeset]);
                    codeset = 0;
                    sb.append(Code128.codeIn(text.charAt(inidx++), codeset));
                    continue;
                }
                sb.append(tabFunc[6][codeset]);
                codeset = 1;
                sb.append(Code128.codeIn(text.charAt(inidx++), codeset));
                continue;
            }
            inidx += Code128.packDigits(sb, text.substring(inidx));
        }
        int iSum = sb.charAt(0);
        for (int iChk = 1; iChk < sb.length(); ++iChk) {
            iSum += sb.charAt(iChk) * iChk;
        }
        sb.append((char)(iSum % 103));
        iBars = 0;
        bars = new char[sb.length() * 6 + 7];
        for (int iPos = 0; iPos < sb.length(); ++iPos) {
            for (int iBar = 0; iBar < 6; ++iBar) {
                bars[iBars++] = tabEncode[sb.charAt(iPos)][iBar];
            }
        }
        bars[iBars++] = 2;
        bars[iBars++] = 3;
        bars[iBars++] = 3;
        bars[iBars++] = '\u0001';
        bars[iBars++] = '\u0001';
        bars[iBars++] = '\u0001';
        bars[iBars++] = 2;
        return bars;
    }

    public static int countDigits(StringBuffer text) {
        return Code128.countDigits(text.toString());
    }

    public static int countDigits(String text) {
        int cnt = 0;
        for (int ii = 0; ii < text.length() && Code128.isdigit(text.charAt(ii)); ++ii) {
            ++cnt;
        }
        return cnt;
    }

    public static boolean ctrlBeforeLower(StringBuffer text) {
        return Code128.ctrlBeforeLower(text.toString());
    }

    public static boolean ctrlBeforeLower(String text) {
        int ii = 0;
        for (ii = 0; ii < text.length(); ++ii) {
            if (Code128.control(text.charAt(ii))) {
                return true;
            }
            if (!Code128.lower(text.charAt(ii))) continue;
            return false;
        }
        return false;
    }

    public static int packDigits(StringBuffer sb, StringBuffer txt) {
        return Code128.packDigits(sb, txt.toString());
    }

    public static int packDigits(StringBuffer sb, String txt) {
        int iCount = 0;
        int ii = 0;
        while (ii + 1 < txt.length() && Code128.isdigit(txt.charAt(ii)) && Code128.isdigit(txt.charAt(ii + 1))) {
            sb.append((char)(10 * (txt.charAt(ii) - 48) + (txt.charAt(ii + 1) - 48)));
            iCount += 2;
            ii += 2;
        }
        return iCount;
    }

    public static char codeIn(char c, int codeset) {
        for (char i = '\u0000'; i < '`'; i = (char)(i + '\u0001')) {
            if (!(codeset == 0 ? c == tabA[i] : c == tabB[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("char " + c + " not in codeset " + codeset);
    }

    public static String decode(char[] bars) {
        char ii;
        char[] e = new char[5];
        char[] E = new char[5];
        boolean decode_succeeded = false;
        char[] b = new char[6];
        char cDecoded = '\u0000';
        int iMode = 0;
        boolean bShift = false;
        boolean bAdd128 = false;
        boolean iTextSize = false;
        int iChkSum = 0;
        boolean bChkSumOk = false;
        StringBuffer sb = new StringBuffer();
        StringBuffer res = new StringBuffer();
        for (ii = '\u0000'; ii <= bars.length - 7; ii = (char)(ii + 6)) {
            int eind;
            for (int kk = 0; kk < 6; kk = (int)((char)(kk + 1))) {
                b[kk] = bars[ii + kk];
            }
            char p = (char)(b[0] + b[1] + b[2] + b[3] + b[4] + b[5]);
            for (eind = 0; eind < 6; eind = (int)((char)(eind + 1))) {
                if (0.5 * (double)p / 11.0 < (double)b[eind] && (double)b[eind] <= 1.5 * (double)p / 11.0) {
                    b[eind] = '\u0001';
                    continue;
                }
                if (1.5 * (double)p / 11.0 < (double)b[eind] && (double)b[eind] <= 2.5 * (double)p / 11.0) {
                    b[eind] = 2;
                    continue;
                }
                if (2.5 * (double)p / 11.0 < (double)b[eind] && (double)b[eind] <= 3.5 * (double)p / 11.0) {
                    b[eind] = 3;
                    continue;
                }
                if (3.5 * (double)p / 11.0 < (double)b[eind] && (double)b[eind] <= 4.5 * (double)p / 11.0) {
                    b[eind] = 4;
                    continue;
                }
                if (4.5 * (double)p / 11.0 < (double)b[eind] && (double)b[eind] <= 5.5 * (double)p / 11.0) {
                    b[eind] = 5;
                    continue;
                }
                if (5.5 * (double)p / 11.0 < (double)b[eind] && (double)b[eind] <= 6.5 * (double)p / 11.0) {
                    b[eind] = 6;
                    continue;
                }
                if (!(6.5 * (double)p / 11.0 < (double)b[eind]) || !((double)b[eind] <= 7.5 * (double)p / 11.0)) continue;
                b[eind] = 7;
            }
            char bar = (char)(b[0] + b[2] + b[4]);
            char space = (char)(b[1] + b[3] + b[5]);
            if (Code128.odd(bar)) {
                throw new IllegalArgumentException("ii=" + ii + " bar(" + bar + ") is not odd!");
            }
            if (Code128.even(space)) {
                throw new IllegalArgumentException("ii=" + ii + " space(" + space + ") is not even!");
            }
            char b1 = b[0];
            char b2 = b[2];
            char b3 = b[4];
            e[1] = (char)(b[0] + b[1]);
            e[2] = (char)(b[1] + b[2]);
            e[3] = (char)(b[2] + b[3]);
            e[4] = (char)(b[3] + b[4]);
            for (eind = 1; eind < 5; eind = (int)((char)(eind + 1))) {
                if (1.5 < (double)e[eind] && (double)e[eind] <= 2.5) {
                    E[eind] = 2;
                    continue;
                }
                if (2.5 < (double)e[eind] && (double)e[eind] <= 3.5) {
                    E[eind] = 3;
                    continue;
                }
                if (3.5 < (double)e[eind] && (double)e[eind] <= 4.5) {
                    E[eind] = 4;
                    continue;
                }
                if (4.5 < (double)e[eind] && (double)e[eind] <= 5.5) {
                    E[eind] = 5;
                    continue;
                }
                if (5.5 < (double)e[eind] && (double)e[eind] <= 6.5) {
                    E[eind] = 6;
                    continue;
                }
                if (!(6.5 < (double)e[eind]) || !((double)e[eind] <= 7.5)) continue;
                E[eind] = 7;
            }
            decode_succeeded = false;
            for (char jj = '\u0000'; jj < tabDecode.length; jj = (char)((char)(jj + 1))) {
                if (E[1] != tabDecode[jj][0] || E[2] != tabDecode[jj][1] || E[3] != tabDecode[jj][2] || E[4] != tabDecode[jj][3]) continue;
                cDecoded = jj;
                decode_succeeded = true;
                break;
            }
            if (!decode_succeeded) {
                throw new IllegalArgumentException("decoding failed ii=" + ii);
            }
            char S = tabDecode[cDecoded][4];
            if (bar != S) {
                throw new IllegalArgumentException("ii=" + ii + " Bar checksum failed!");
            }
            if (!((double)S - 1.75 < (double)(b1 + b2 + b3)) || !((double)(b1 + b2 + b3) < (double)S + 1.75)) {
                throw new IllegalArgumentException("ii=" + ii + " One module edge error!");
            }
            if (cDecoded > 'k') {
                throw new IllegalArgumentException("Decoded > 107");
            }
            sb.append(cDecoded);
        }
        iChkSum = sb.charAt(0);
        for (ii = '\u0001'; ii < sb.length() - 2; ii = (char)((char)(ii + 1))) {
            iChkSum += sb.charAt(ii) * ii;
        }
        if (sb.charAt(sb.length() - 2) != iChkSum % 103) {
            throw new IllegalArgumentException("Symbol checksum of '" + sb.toString() + "' failed! sum = " + sb.charAt(sb.length() - 2) + " should be " + iChkSum % 103);
        }
        block49: for (ii = '\u0000'; ii < sb.length() - 2; ii = (char)((char)(ii + 1))) {
            cDecoded = sb.charAt(ii);
            switch (iMode) {
                case 0: {
                    switch (cDecoded) {
                        case '`': {
                            continue block49;
                        }
                        case 'a': {
                            continue block49;
                        }
                        case 'b': {
                            iMode = 1;
                            bShift = true;
                            continue block49;
                        }
                        case 'c': {
                            iMode = 2;
                            continue block49;
                        }
                        case 'd': {
                            iMode = 1;
                            continue block49;
                        }
                        case 'e': {
                            bAdd128 = true;
                            continue block49;
                        }
                        case 'f': {
                            continue block49;
                        }
                        case 'g': {
                            iMode = 0;
                            continue block49;
                        }
                        case 'h': {
                            iMode = 1;
                            continue block49;
                        }
                        case 'i': {
                            iMode = 2;
                            continue block49;
                        }
                        case 'j': {
                            if (bChkSumOk) {
                                return res.toString();
                            }
                            throw new IllegalArgumentException("Check Sum failed");
                        }
                        case 'k': {
                            throw new IllegalArgumentException("STOP BACKWARDS");
                        }
                    }
                    if (bAdd128) {
                        res.append((char)(tabA[cDecoded] + 128));
                        bAdd128 = false;
                    } else {
                        res.append(tabA[cDecoded]);
                    }
                    if (!bShift) continue block49;
                    iMode = 1;
                    bShift = false;
                    continue block49;
                }
                case 1: {
                    switch (cDecoded) {
                        case '`': {
                            continue block49;
                        }
                        case 'a': {
                            continue block49;
                        }
                        case 'b': {
                            iMode = 0;
                            bShift = true;
                            continue block49;
                        }
                        case 'c': {
                            iMode = 2;
                            continue block49;
                        }
                        case 'd': {
                            bAdd128 = true;
                            continue block49;
                        }
                        case 'e': {
                            iMode = 0;
                            continue block49;
                        }
                        case 'f': {
                            continue block49;
                        }
                        case 'g': {
                            iMode = 0;
                            continue block49;
                        }
                        case 'h': {
                            iMode = 1;
                            continue block49;
                        }
                        case 'i': {
                            iMode = 2;
                            continue block49;
                        }
                        case 'j': {
                            if (bChkSumOk) {
                                return res.toString();
                            }
                            throw new IllegalArgumentException("Check Sum failed");
                        }
                        case 'k': {
                            throw new IllegalArgumentException("STOP BACKWARDS");
                        }
                    }
                    if (bAdd128) {
                        res.append((char)(tabB[cDecoded] + 128));
                        bAdd128 = false;
                    } else {
                        res.append(tabB[cDecoded]);
                    }
                    if (!bShift) continue block49;
                    iMode = 0;
                    bShift = false;
                    continue block49;
                }
                case 2: {
                    switch (cDecoded) {
                        case 'd': {
                            iMode = 1;
                            continue block49;
                        }
                        case 'e': {
                            iMode = 0;
                            continue block49;
                        }
                        case 'f': {
                            continue block49;
                        }
                        case 'g': {
                            iMode = 0;
                            continue block49;
                        }
                        case 'h': {
                            iMode = 1;
                            continue block49;
                        }
                        case 'i': {
                            iMode = 2;
                            continue block49;
                        }
                        case 'j': {
                            if (bChkSumOk) {
                                return res.toString();
                            }
                            throw new IllegalArgumentException("Check Sum failed");
                        }
                        case 'k': {
                            throw new IllegalArgumentException("STOP BACKWARDS");
                        }
                    }
                    if (cDecoded > 'c') {
                        throw new IllegalArgumentException("Decoded > 99");
                    }
                    res.append(cDecoded / 10);
                    res.append(cDecoded % 10);
                }
            }
        }
        return res.toString();
    }

    public static boolean odd(int n) {
        return n % 2 != 0;
    }

    public static boolean even(int n) {
        return !Code128.odd(n);
    }

    public static boolean lower(char c) {
        return c >= '`' && c <= '\u007f';
    }

    public static boolean control(char c) {
        return c >= '\u0000' && c <= '\u001f';
    }

    public static boolean isdigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static void main(String[] args) {
        int l = 0;
        String sl = null;
        try {
            for (l = 0; l < 1000; ++l) {
                sl = String.valueOf(l);
                Code128 code128 = new Code128(sl);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

