/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.vesalainen.util.Matcher;

public class SimpleMatcher
implements Matcher<String> {
    private final String expr;
    private final byte[] expression;
    private int idx;
    private Matcher.Status okStatus = Matcher.Status.Ok;

    public SimpleMatcher(String expr) {
        this(expr, StandardCharsets.US_ASCII);
    }

    public SimpleMatcher(String expr, Charset charset) {
        if (expr.isEmpty()) {
            throw new IllegalArgumentException("empty expression");
        }
        if (expr.endsWith("*")) {
            throw new IllegalArgumentException(expr + " ending with '*'");
        }
        this.expr = expr;
        this.expression = expr.getBytes(charset);
    }

    public SimpleMatcher(byte[] expression) {
        if (expression.length == 0) {
            throw new IllegalArgumentException("empty expression");
        }
        if (expression[expression.length - 1] == 42) {
            throw new IllegalArgumentException("expr ending with '*'");
        }
        this.expr = new String(expression);
        this.expression = expression;
    }

    public String getExpression() {
        return this.expr;
    }

    @Override
    public Matcher.Status match(int cc) {
        if (this.expression[this.idx] == 42) {
            this.okStatus = Matcher.Status.WillMatch;
            if (cc == this.expression[this.idx + 1]) {
                ++this.idx;
            } else {
                return this.okStatus;
            }
        }
        if (this.expression[this.idx] == cc || this.expression[this.idx] == 63) {
            ++this.idx;
            if (this.idx == this.expression.length) {
                this.idx = 0;
                this.okStatus = Matcher.Status.Ok;
                return Matcher.Status.Match;
            }
            return this.okStatus;
        }
        this.idx = 0;
        this.okStatus = Matcher.Status.Ok;
        return Matcher.Status.Error;
    }

    @Override
    public void clear() {
        this.idx = 0;
        this.okStatus = Matcher.Status.Ok;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Arrays.hashCode(this.expression);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleMatcher other = (SimpleMatcher)obj;
        return Arrays.equals(this.expression, other.expression);
    }

    public String toString() {
        return "SimpleMatcher{expr=" + this.expr + '}';
    }

    @Override
    public String getMatched() {
        return this.expr;
    }
}

