/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.vesalainen.util.HashMapList;
import org.vesalainen.util.MapList;
import org.vesalainen.util.Matcher;

public class OrMatcher<T>
implements Matcher,
Iterable<Matcher> {
    private final Set<Matcher> matchers = new HashSet<Matcher>();
    private final Set<Matcher> active = new HashSet<Matcher>();
    private final MapList<Matcher, T> map = new HashMapList<Matcher, T>();
    private Matcher lastMatched;

    public void add(Matcher matcher) {
        this.matchers.add(matcher);
        this.active.add(matcher);
    }

    public void add(Matcher matcher, T attachment) {
        this.add(matcher);
        this.map.add(matcher, attachment);
    }

    public void add(Matcher matcher, Collection<T> attachments) {
        this.add(matcher);
        for (T attachment : attachments) {
            this.map.add(matcher, attachment);
        }
    }

    @Override
    public Matcher.Status match(int cc) {
        int highest = -1;
        Iterator<Matcher> iterator = this.active.iterator();
        while (iterator.hasNext()) {
            Matcher matcher = iterator.next();
            Matcher.Status s = matcher.match(cc);
            highest = Math.max(highest, s.ordinal());
            switch (s) {
                case Match: {
                    this.lastMatched = matcher;
                    this.clear();
                    return s;
                }
                case WillMatch: {
                    this.lastMatched = matcher;
                    return s;
                }
                case Error: {
                    iterator.remove();
                }
            }
        }
        if (this.active.isEmpty()) {
            this.clear();
            return Matcher.Status.Error;
        }
        return Matcher.Status.values()[highest];
    }

    public List<T> getLastMatched() {
        return this.map.get(this.lastMatched);
    }

    @Override
    public void clear() {
        for (Matcher matcher : this.matchers) {
            matcher.clear();
        }
        this.active.addAll(this.matchers);
    }

    @Override
    public Iterator<Matcher> iterator() {
        return this.matchers.iterator();
    }

    public boolean isEmpty() {
        return this.matchers.isEmpty();
    }

    public Object getMatched() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

