/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public class Merger {
    public static <T> Iterator<T> merge(Comparator<T> comp, Iterator<T> ... iterables) {
        switch (iterables.length) {
            case 0: {
                throw new IllegalArgumentException("no iterables");
            }
            case 1: {
                return iterables[0];
            }
            case 2: {
                return new IteratorImpl<T>(comp, iterables[0], iterables[1]);
            }
        }
        return new IteratorImpl<T>(comp, iterables[0], Merger.merge(comp, Arrays.copyOfRange(iterables, 1, iterables.length)));
    }

    private static class IteratorImpl<T>
    implements Iterator<T> {
        private final Comparator<T> comp;
        private final Iterator<T> i1;
        private final Iterator<T> i2;
        private T v1;
        private T v2;

        public IteratorImpl(Comparator<T> comp, Iterator<T> i1, Iterator<T> i2) {
            this.comp = comp;
            this.i1 = i1;
            this.i2 = i2;
            this.v1 = i1.next();
            this.v2 = i2.next();
        }

        @Override
        public boolean hasNext() {
            return this.v1 != null || this.v2 != null;
        }

        @Override
        public T next() {
            if (this.v1 == null) {
                return this.next2();
            }
            if (this.v2 == null) {
                return this.next1();
            }
            if (this.comp.compare(this.v1, this.v2) < 0) {
                return this.next1();
            }
            return this.next2();
        }

        private T next1() {
            T tmp = this.v1;
            this.v1 = this.i1.hasNext() ? this.i1.next() : null;
            return tmp;
        }

        private T next2() {
            T tmp = this.v2;
            this.v2 = this.i2.hasNext() ? this.i2.next() : null;
            return tmp;
        }
    }
}

