/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class Lists {
    private static final ThreadLocal<Locale> threadLocale = new ThreadLocal();
    private static final ThreadLocal<String> threadFormat = new ThreadLocal();

    public static final void setFormat(String format, Locale locale) {
        threadFormat.set(format);
        threadLocale.set(locale);
    }

    public static final void removeFormat() {
        threadFormat.remove();
        threadLocale.remove();
    }

    private static String format(Object ob) {
        String format = threadFormat.get();
        Locale locale = threadLocale.get();
        if (format != null && locale != null) {
            return String.format(locale, format, ob);
        }
        return ob.toString();
    }

    public static final <T> List<T> create(T ... items) {
        ArrayList list = new ArrayList();
        Lists.populate(list, items);
        return list;
    }

    public static final <T> void populate(Collection<T> collection, T ... items) {
        for (T t : items) {
            collection.add(t);
        }
    }

    public static final <T> void remove(Collection<T> collection, T ... items) {
        for (T t : items) {
            collection.remove(t);
        }
    }

    public static final String print(String delim, Collection<?> collection) {
        return Lists.print(null, delim, null, null, null, collection);
    }

    public static final String print(String start, String delim, String quotStart, String quotEnd, String end, Collection<?> collection) {
        try {
            StringBuilder out = new StringBuilder();
            Lists.print((Appendable)out, start, delim, quotStart, quotEnd, end, collection);
            return out.toString();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static final void print(Appendable out, String start, String delim, String quotStart, String quotEnd, String end, Collection<?> collection) throws IOException {
        Lists.append(start, out);
        boolean first = true;
        for (Object ob : collection) {
            if (!first) {
                Lists.append(delim, out);
            } else {
                first = false;
            }
            Lists.append(quotStart, out);
            out.append(Lists.format(ob));
            Lists.append(quotEnd, out);
        }
        Lists.append(end, out);
    }

    public static final String print(String delim, Object ... array) {
        return Lists.print(null, delim, null, null, null, array);
    }

    public static final String print(String start, String delim, String quotStart, String quotEnd, String end, Object ... array) {
        try {
            StringBuilder out = new StringBuilder();
            Lists.print((Appendable)out, start, delim, quotStart, quotEnd, end, array);
            return out.toString();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static final void print(Appendable out, String start, String delim, String quotStart, String quotEnd, String end, Object ... array) throws IOException {
        Lists.append(start, out);
        boolean first = true;
        for (Object ob : array) {
            if (!first) {
                Lists.append(delim, out);
            } else {
                first = false;
            }
            Lists.append(quotStart, out);
            out.append(Lists.format(ob));
            Lists.append(quotEnd, out);
        }
        Lists.append(end, out);
    }

    private static void append(String str, Appendable out) throws IOException {
        if (str != null) {
            out.append(str);
        }
    }
}

