/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.vesalainen.io.AppendablePrinter;

public class InterfaceTracer
implements InvocationHandler {
    protected Object obj;
    protected AppendablePrinter printer;

    protected InterfaceTracer(Object ob) {
        this.obj = ob;
    }

    public static <T> T getTracer(Class<T> intf, T ob) {
        return InterfaceTracer.getTracer(intf, new InterfaceTracer(ob), ob);
    }

    protected static <T> T getTracer(Class<T> intf, InterfaceTracer tracer, T ob) {
        tracer.setAppendable(System.err);
        tracer.setObj(ob);
        return (T)Proxy.newProxyInstance(intf.getClassLoader(), new Class[]{intf}, (InvocationHandler)tracer);
    }

    public static <T> T getTracer(Class<T> intf, T ob, Appendable appendable) {
        return InterfaceTracer.getTracer(intf, new InterfaceTracer(ob), ob, appendable);
    }

    protected static <T> T getTracer(Class<T> intf, InterfaceTracer tracer, T ob, Appendable appendable) {
        tracer.setAppendable(appendable);
        tracer.setObj(ob);
        return (T)Proxy.newProxyInstance(intf.getClassLoader(), new Class[]{intf}, (InvocationHandler)tracer);
    }

    private void setAppendable(Appendable appendable) {
        this.printer = new AppendablePrinter(appendable);
    }

    private void setObj(Object obj) {
        this.obj = obj;
    }

    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object res = null;
        if (this.obj != null) {
            res = method.invoke(this.obj, args);
        }
        this.printer.print(method.getName());
        this.printer.print("(");
        if (args != null) {
            boolean first = true;
            for (Object arg : args) {
                if (!first) {
                    this.printer.print(", ");
                }
                this.printer.print(arg);
                first = false;
            }
        }
        this.printer.print(")");
        if (this.obj != null && !Void.TYPE.equals(method.getReturnType())) {
            this.printer.println(" = " + res);
        } else {
            this.printer.println();
        }
        return res;
    }
}

