/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class EasterCalendar
extends GregorianCalendar {
    private Locale locale;
    private boolean finnish;

    public EasterCalendar(int i, int i1, int i2, int i3, int i4, int i5) {
        super(i, i1, i2, i3, i4, i5);
        this.locale = Locale.getDefault();
        this.finnish = "FIN".equals(this.locale.getISO3Country());
    }

    public EasterCalendar(int i, int i1, int i2, int i3, int i4) {
        super(i, i1, i2, i3, i4);
        this.locale = Locale.getDefault();
        this.finnish = "FIN".equals(this.locale.getISO3Country());
    }

    public EasterCalendar(int i, int i1, int i2) {
        super(i, i1, i2);
        this.locale = Locale.getDefault();
        this.finnish = "FIN".equals(this.locale.getISO3Country());
    }

    public EasterCalendar(TimeZone tz, Locale locale) {
        super(tz, locale);
        this.locale = locale;
        this.finnish = "FIN".equals(locale.getISO3Country());
    }

    public EasterCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public EasterCalendar(TimeZone tz) {
        this(tz, Locale.getDefault());
    }

    public EasterCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public boolean isHolyday() {
        if (this.get(7) == 1) {
            return true;
        }
        if (this.get(2) == 0 && this.get(5) == 1) {
            return true;
        }
        if (this.get(2) == 0 && this.get(5) == 6) {
            return true;
        }
        if (this.get(2) == 4 && this.get(5) == 1) {
            return true;
        }
        if (this.get(2) == 5 && this.get(7) == 6 && this.get(5) <= 25 && this.get(5) > 18) {
            return this.finnish;
        }
        if (this.get(2) == 11 && this.get(5) == 6) {
            return this.finnish;
        }
        if (this.get(2) == 11 && this.get(5) == 24) {
            return true;
        }
        if (this.get(2) == 11 && this.get(5) == 25) {
            return true;
        }
        if (this.get(2) == 11 && this.get(5) == 26) {
            return true;
        }
        if (this.isEaster(this)) {
            return true;
        }
        this.add(5, 2);
        if (this.isEaster(this)) {
            this.add(5, -2);
            return true;
        }
        this.add(5, -2);
        this.add(5, -1);
        if (this.isEaster(this)) {
            this.add(5, 1);
            return true;
        }
        this.add(5, 1);
        this.add(5, -39);
        if (this.isEaster(this)) {
            this.add(5, 39);
            return this.finnish;
        }
        this.add(5, 39);
        return false;
    }

    public boolean isEaster(Calendar cal) {
        int Y = cal.get(1);
        int C = Y / 100;
        int N = Y - 19 * (Y / 19);
        int K = (C - 17) / 25;
        int I = C - C / 4 - (C - K) / 3 + 19 * N + 15;
        I -= 30 * (I / 30);
        I -= I / 28 * (1 - I / 28 * (29 / (I + 1)) * ((21 - N) / 11));
        int J = Y + Y / 4 + I + 2 - C + C / 4;
        J -= 7 * (J / 7);
        int L = I - J;
        int M = 3 + (L + 40) / 44;
        int D = L + 28 - 31 * (M / 4);
        return M == cal.get(2) + 1 && D == cal.get(5);
    }
}

