/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.util.Arrays;

public class BitArray {
    private byte[] array;

    public BitArray(int bits) {
        this(new byte[(int)Math.ceil((double)bits / 8.0)]);
    }

    public BitArray(byte[] array) {
        this.array = array;
    }

    public void set(int index, boolean value) {
        if (value) {
            int n = index / 8;
            this.array[n] = (byte)(this.array[n] | 1 << index % 8);
        } else {
            int n = index / 8;
            this.array[n] = (byte)(this.array[n] & ~(1 << index % 8));
        }
    }

    public boolean isSet(int index) {
        return (this.array[index / 8] & 1 << index % 8) != 0;
    }

    public void setAll(boolean value) {
        if (value) {
            Arrays.fill(this.array, (byte)-1);
        } else {
            Arrays.fill(this.array, (byte)0);
        }
    }

    public byte[] getArray() {
        return this.array;
    }
}

