/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.math.BigInteger;

public class BankingCode {
    public static String create(String prefix, String code) {
        BigInteger bbban = new BigInteger(code);
        StringBuilder sb = new StringBuilder();
        sb.append(code);
        for (char cc : prefix.toCharArray()) {
            int k = cc - 65 + 10;
            sb.append(k);
        }
        sb.append("00");
        BigInteger bi = new BigInteger(sb.toString());
        BigInteger remainder = bi.remainder(new BigInteger("97"));
        int cd = 98 - remainder.intValue();
        return String.format("%s%02d%d", prefix, cd, bbban);
    }

    public static void check(String str) {
        String code = str.replace(" ", "");
        String bbanString = code.substring(4);
        String prefix = code.substring(0, 2);
        String iban = BankingCode.create(prefix, bbanString);
        if (!code.equals(iban)) {
            throw new IllegalArgumentException(str + " illegal format");
        }
    }

    public static String format(String code) {
        BankingCode.check(code);
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < code.length(); ii += 4) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(code.substring(ii, Math.min(ii + 4, code.length())));
        }
        return sb.toString();
    }
}

