/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.vesalainen.util.HashMapList;
import org.vesalainen.util.MapList;

public abstract class AbstractProvisioner<T> {
    private final MapList<String, InstanceMethod> map = new HashMapList<String, InstanceMethod>();

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void attach(T ob) {
        for (Method method : ob.getClass().getMethods()) {
            Setting setting = method.getAnnotation(Setting.class);
            if (setting == null) continue;
            String name = setting.value();
            Class<?>[] params = method.getParameterTypes();
            if (params.length != 1) {
                throw new IllegalArgumentException("@Setting(" + name + ") argument count != 1");
            }
            InstanceMethod instanceMethod = new InstanceMethod(ob, method);
            Object value = this.getValue(name);
            if (value != null) {
                instanceMethod.invoke(value);
            }
            this.map.add(name, instanceMethod);
        }
    }

    public void detach(T ob) {
        Iterator ki = this.map.entrySet().iterator();
        while (ki.hasNext()) {
            Map.Entry entry = ki.next();
            Iterator li = ((List)entry.getValue()).iterator();
            while (li.hasNext()) {
                InstanceMethod im = (InstanceMethod)li.next();
                if (!im.instance.equals(ob)) continue;
                li.remove();
            }
            if (!((List)entry.getValue()).isEmpty()) continue;
            ki.remove();
        }
    }

    public abstract Object getValue(String var1);

    public void setValue(String name, Object value) {
        for (InstanceMethod im : this.map.get(name)) {
            im.invoke(value);
        }
    }

    private class InstanceMethod {
        T instance;
        Method method;

        private InstanceMethod(T instance, Method method) {
            this.instance = instance;
            this.method = method;
        }

        private void invoke(Object arg) {
            try {
                this.method.invoke(this.instance, arg);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Setting {
        public String value();
    }
}

