/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.vesalainen.util.MapSet;

public abstract class AbstractMapSet<K, V>
implements MapSet<K, V> {
    protected Map<K, Set<V>> map;

    protected AbstractMapSet(Map<K, Set<V>> map) {
        this.map = map;
    }

    protected abstract Set<V> createSet();

    @Override
    public boolean contains(K key, V value) {
        Object set = this.get(key);
        if (set == null) {
            return false;
        }
        return set.contains(value);
    }

    @Override
    public void add(K key, V value) {
        Set<V> set = this.get(key);
        if (set == null) {
            set = this.createSet();
            this.put(key, set);
        }
        set.add(value);
    }

    @Override
    public void addAll(K key, Collection<V> value) {
        Set<V> set = this.get(key);
        if (set == null) {
            set = this.createSet();
            this.put(key, set);
        }
        if (value != null) {
            set.addAll(value);
        }
    }

    @Override
    public Set<V> set(K key, Collection<V> value) {
        Set<V> set = this.get(key);
        if (set == null) {
            set = this.createSet();
            this.put(key, set);
        }
        set.clear();
        if (value != null) {
            set.addAll(value);
        }
        return set;
    }

    @Override
    public void addAll(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean removeItem(K key, V value) {
        Object set = this.get(key);
        boolean res = set.remove(value);
        if (set.isEmpty()) {
            this.remove(key);
        }
        return res;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<V> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Set<V> put(K key, Set<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public Set<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Set<V>> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Set<V>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Set<V> getOrDefault(Object key, Set<V> defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Set<V>> action) {
        this.map.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super Set<V>, ? extends Set<V>> function) {
        this.map.replaceAll(function);
    }

    @Override
    public Set<V> putIfAbsent(K key, Set<V> value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public boolean replace(K key, Set<V> oldValue, Set<V> newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public Set<V> replace(K key, Set<V> value) {
        return this.map.replace(key, value);
    }

    @Override
    public Set<V> computeIfAbsent(K key, Function<? super K, ? extends Set<V>> mappingFunction) {
        return this.map.computeIfAbsent((K)key, (Function<? super K, Set<? extends Set<V>>>)mappingFunction);
    }

    @Override
    public Set<V> computeIfPresent(K key, BiFunction<? super K, ? super Set<V>, ? extends Set<V>> remappingFunction) {
        return this.map.computeIfPresent((K)key, (BiFunction<? super K, Set<? extends Set<V>>, Set<? extends Set<V>>>)remappingFunction);
    }

    @Override
    public Set<V> compute(K key, BiFunction<? super K, ? super Set<V>, ? extends Set<V>> remappingFunction) {
        return this.map.compute((K)key, (BiFunction<? super K, Set<? extends Set<V>>, Set<? extends Set<V>>>)remappingFunction);
    }

    @Override
    public Set<V> merge(K key, Set<V> value, BiFunction<? super Set<V>, ? super Set<V>, ? extends Set<V>> remappingFunction) {
        return this.map.merge(key, value, remappingFunction);
    }
}

