/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.vesalainen.util.MapList;
import org.vesalainen.util.OrderedList;

public abstract class AbstractMapList<K, V>
implements MapList<K, V> {
    protected Map<K, List<V>> map;
    protected Comparator<V> comparator;

    public AbstractMapList(Map<K, List<V>> map, Comparator<V> comparator) {
        this.map = map;
        this.comparator = comparator;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public List<V> put(K key, List<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public List<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public List<V> getOrDefault(Object key, List<V> defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super List<V>> action) {
        this.map.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super List<V>, ? extends List<V>> function) {
        this.map.replaceAll(function);
    }

    @Override
    public List<V> putIfAbsent(K key, List<V> value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public boolean replace(K key, List<V> oldValue, List<V> newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public List<V> replace(K key, List<V> value) {
        return this.map.replace(key, value);
    }

    @Override
    public List<V> computeIfAbsent(K key, Function<? super K, ? extends List<V>> mappingFunction) {
        return this.map.computeIfAbsent((K)key, (Function<? super K, List<? extends List<V>>>)mappingFunction);
    }

    @Override
    public List<V> computeIfPresent(K key, BiFunction<? super K, ? super List<V>, ? extends List<V>> remappingFunction) {
        return this.map.computeIfPresent((K)key, (BiFunction<? super K, List<? extends List<V>>, List<? extends List<V>>>)remappingFunction);
    }

    @Override
    public List<V> compute(K key, BiFunction<? super K, ? super List<V>, ? extends List<V>> remappingFunction) {
        return this.map.compute((K)key, (BiFunction<? super K, List<? extends List<V>>, List<? extends List<V>>>)remappingFunction);
    }

    @Override
    public List<V> merge(K key, List<V> value, BiFunction<? super List<V>, ? super List<V>, ? extends List<V>> remappingFunction) {
        return this.map.merge(key, value, remappingFunction);
    }

    @Override
    public void add(K key, V value) {
        this.add(key, -1, value);
    }

    @Override
    public void add(K key, int index, V value) {
        List<V> list = this.map.get(key);
        if (list == null) {
            list = this.createList();
            this.put(key, list);
        }
        if (index != -1) {
            list.add(index, value);
        } else {
            list.add(value);
        }
    }

    @Override
    public List<V> set(K key, Collection<V> value) {
        List<V> list = this.map.get(key);
        if (list == null) {
            list = this.createList();
            this.put(key, list);
        }
        list.clear();
        list.addAll(value);
        return list;
    }

    @Override
    public List<V> get(Object key) {
        List<V> list = this.map.get(key);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    @Override
    public void addAll(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean removeItem(K key, V value) {
        Object list = this.get(key);
        boolean res = list.remove(value);
        if (list.isEmpty()) {
            this.remove(key);
        }
        return res;
    }

    @Override
    public void addAll(K key, Collection<V> collection) {
        for (V value : collection) {
            this.add(key, value);
        }
    }

    @Override
    public boolean contains(K key, V value) {
        Object list = this.get(key);
        if (list == null) {
            return false;
        }
        return list.contains(value);
    }

    protected List<V> createList() {
        if (this.comparator != null) {
            return new OrderedList<V>(this.comparator);
        }
        return new ArrayList();
    }
}

