/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.ejml.data.DenseMatrix64F;
import org.vesalainen.math.Circle;
import org.vesalainen.math.Point;
import org.vesalainen.math.Polygon;
import org.vesalainen.ui.AbstractView;

public class Plotter
extends AbstractView {
    private final BufferedImage image;
    private final Graphics2D graphics2D;
    private Color color = Color.BLACK;
    private final List<Drawable> drawables = new ArrayList<Drawable>();
    private File dir;

    public Plotter(int width, int height) {
        this(width, height, new Color(255, 255, 255, 255));
    }

    public Plotter(int width, int height, Color background) {
        super.setScreen(width, height);
        this.image = new BufferedImage(width, height, 6);
        this.graphics2D = this.image.createGraphics();
        this.graphics2D.setBackground(background);
        this.graphics2D.clearRect(0, 0, width, height);
    }

    public void clear() {
        this.graphics2D.clearRect(0, 0, (int)this.width, (int)this.height);
        this.drawables.clear();
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void drawCircle(Circle circle) {
        this.drawCircle(circle.getX(), circle.getY(), circle.getRadius());
    }

    public void drawCircle(double x, double y, double r) {
        this.updateCircle(x, y, r);
        this.drawables.add(new Circl(this.color, x, y, r));
    }

    public void drawPoint(DenseMatrix64F point) {
        assert (point.numCols == 1);
        assert (point.numRows == 2);
        double[] d = point.data;
        double x = d[0];
        double y = d[1];
        this.updatePoint(x, y);
        this.drawables.add(new Pnt(this.color, x, y));
    }

    public void drawPoint(Point p) {
        this.drawPoint(p.getX(), p.getY());
    }

    public void drawPoint(double x, double y) {
        this.updatePoint(x, y);
        this.drawables.add(new Pnt(this.color, x, y));
    }

    public void drawPolygon(Polygon polygon) {
        this.updatePolygon(polygon);
        this.drawables.add(new Poly(this.color, polygon));
    }

    public void drawPolygon(DenseMatrix64F polygon) {
        this.updatePolygon(polygon);
        this.drawables.add(new Poly(this.color, polygon));
    }

    public void drawLine(Point p1, Point p2) {
        this.drawLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.updatePoint(x1, y1);
        this.updatePoint(x2, y2);
        this.drawables.add(new Lin(this.color, x1, y1, x2, y2));
    }

    public void drawCoordinateLine(double x1, double y1, double x2, double y2) {
        this.updatePoint(x1, y1);
        this.updatePoint(x2, y2);
        this.drawables.add(0, new Lin(this.color, x1, y1, x2, y2));
    }

    public void drawLines(Polygon polygon) {
        this.updatePolygon(polygon);
        this.drawables.add(new Lines(this.color, polygon));
    }

    public void drawLines(DenseMatrix64F polygon) {
        this.updatePolygon(polygon);
        this.drawables.add(new Lines(this.color, polygon));
    }

    public void drawCoordinates() {
        Color safe = this.color;
        int minx = (int)(this.xMin - 1.0);
        int maxx = (int)(this.xMax + 1.0);
        int miny = (int)(this.yMin - 1.0);
        int maxy = (int)(this.yMax + 1.0);
        this.color = Color.BLACK;
        this.drawCoordinateLine(minx, 0.0, maxx, 0.0);
        this.drawCoordinateLine(0.0, miny, 0.0, maxy);
        this.color = Color.LIGHT_GRAY;
        for (int x = minx; x <= maxx; ++x) {
            this.drawCoordinateLine(x, miny, x, maxy);
        }
        for (int y = miny; y <= maxy; ++y) {
            this.drawCoordinateLine(minx, y, maxx, y);
        }
        this.color = safe;
    }

    @Override
    public void setScreen(double width, double height) {
        throw new UnsupportedOperationException("Screen coordinates must be set in constructor");
    }

    public void plotToDocFiles(Class<?> cls, String filename, String ext) throws IOException {
        String dirName = String.format("src/main/resources/%s/doc-files", cls.getPackage().getName().replace('.', '/'));
        File dir = new File(dirName);
        dir.mkdirs();
        File file = new File(dir, filename + "." + ext);
        this.plot(file, ext);
    }

    public void plot(String filename, String ext) throws IOException {
        File file = this.dir != null ? new File(this.dir, filename + '.' + ext) : new File(filename + '.' + ext);
        this.plot(file, ext);
    }

    public void plot(File file, String ext) throws IOException {
        for (Drawable d : this.drawables) {
            d.draw(this.graphics2D);
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            ImageIO.write((RenderedImage)this.image, ext, fos);
        }
    }

    private class Lines
    extends Drawable {
        double[] data;

        public Lines(Color color, Polygon polygon) {
            super(color);
            DenseMatrix64F m = polygon.points;
            this.data = Arrays.copyOf(m.data, m.getNumElements());
        }

        private Lines(Color color, DenseMatrix64F m) {
            super(color);
            this.data = Arrays.copyOf(m.data, m.getNumElements());
        }

        @Override
        protected void draw(Graphics2D graphics2D) {
            super.draw(graphics2D);
            int len = this.data.length / 2;
            if (len >= 2) {
                int x1 = (int)Plotter.this.toScreenX(this.data[0]);
                int y1 = (int)Plotter.this.toScreenY(this.data[1]);
                for (int r = 1; r < len; ++r) {
                    int x2 = (int)Plotter.this.toScreenX(this.data[2 * r]);
                    int y2 = (int)Plotter.this.toScreenY(this.data[2 * r + 1]);
                    graphics2D.drawLine(x1, y1, x2, y2);
                    x1 = x2;
                    y1 = y2;
                }
            }
        }
    }

    private class Lin
    extends Drawable {
        double x1;
        double y1;
        double x2;
        double y2;

        public Lin(Color color, double x1, double y1, double x2, double y2) {
            super(color);
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        @Override
        protected void draw(Graphics2D graphics2D) {
            super.draw(graphics2D);
            int sx1 = (int)Plotter.this.toScreenX(this.x1);
            int sy1 = (int)Plotter.this.toScreenY(this.y1);
            int sx2 = (int)Plotter.this.toScreenX(this.x2);
            int sy2 = (int)Plotter.this.toScreenY(this.y2);
            graphics2D.drawLine(sx1, sy1, sx2, sy2);
        }
    }

    private class Poly
    extends Drawable {
        double[] data;

        public Poly(Color color, Polygon polygon) {
            super(color);
            DenseMatrix64F m = polygon.points;
            this.data = Arrays.copyOf(m.data, m.getNumElements());
        }

        private Poly(Color color, DenseMatrix64F m) {
            super(color);
            this.data = Arrays.copyOf(m.data, m.getNumElements());
        }

        @Override
        protected void draw(Graphics2D graphics2D) {
            super.draw(graphics2D);
            int len = this.data.length / 2;
            if (len >= 2) {
                int x1 = (int)Plotter.this.toScreenX(this.data[2 * (len - 1)]);
                int y1 = (int)Plotter.this.toScreenY(this.data[2 * (len - 1) + 1]);
                for (int r = 0; r < len; ++r) {
                    int x2 = (int)Plotter.this.toScreenX(this.data[2 * r]);
                    int y2 = (int)Plotter.this.toScreenY(this.data[2 * r + 1]);
                    graphics2D.drawLine(x1, y1, x2, y2);
                    x1 = x2;
                    y1 = y2;
                }
            }
        }
    }

    private class Circl
    extends Pnt {
        double r;

        public Circl(Color color, double x, double y, double r) {
            super(color, x, y);
            this.r = r;
        }

        @Override
        protected void draw(Graphics2D graphics2D) {
            super.draw(graphics2D);
            int sx = (int)Plotter.this.toScreenX(this.x);
            int sy = (int)Plotter.this.toScreenY(this.y);
            int sr = (int)Plotter.this.scaleToScreen(this.r);
            int sr2 = 2 * sr;
            graphics2D.drawOval(sx - sr, sy - sr, sr2, sr2);
        }
    }

    private class Pnt
    extends Drawable {
        double x;
        double y;

        public Pnt(Color color, double x, double y) {
            super(color);
            this.x = x;
            this.y = y;
        }

        @Override
        protected void draw(Graphics2D graphics2D) {
            super.draw(graphics2D);
            int sx = (int)Plotter.this.toScreenX(this.x);
            int sy = (int)Plotter.this.toScreenY(this.y);
            graphics2D.drawOval(sx - 2, sy - 2, 4, 4);
        }
    }

    private class Drawable {
        Color color;

        public Drawable(Color color) {
            this.color = color;
        }

        protected void draw(Graphics2D graphics2D) {
            graphics2D.setColor(this.color);
        }
    }
}

