/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.ui;

import org.ejml.data.DenseMatrix64F;
import org.vesalainen.math.Circle;
import org.vesalainen.math.Polygon;
import org.vesalainen.math.Rect;

public class AbstractView {
    protected double width = Double.NaN;
    protected double height = Double.NaN;
    protected double xMax = Double.NEGATIVE_INFINITY;
    protected double yMax = Double.NEGATIVE_INFINITY;
    protected double xMin = Double.POSITIVE_INFINITY;
    protected double yMin = Double.POSITIVE_INFINITY;
    protected double xOff;
    protected double yOff;
    protected double scale;
    protected boolean calculated;

    public AbstractView() {
    }

    public AbstractView(double xMin, double xMax, double yMin, double yMax) {
        this.setRect(xMin, xMax, yMin, yMax);
    }

    public void setScreen(double width, double height) {
        if (this.width != width) {
            this.width = width;
            this.calculated = false;
        }
        if (this.height != height) {
            this.height = height;
            this.calculated = false;
        }
    }

    private void calculate() {
        double aspect = this.width / this.height;
        double xyWidth = this.xMax - this.xMin;
        double xyHeight = this.yMax - this.yMin;
        double xyAspect = xyWidth / xyHeight;
        if (aspect > xyAspect) {
            this.scale = this.height / xyHeight;
            this.xOff = -this.scale * this.xMin + (this.width - this.scale * xyWidth) / 2.0;
            this.yOff = this.scale * this.yMin + this.height;
        } else {
            this.scale = this.width / xyWidth;
            this.xOff = -this.scale * this.xMin;
            this.yOff = this.scale * this.yMin + this.height / 2.0 + this.scale * xyHeight / 2.0;
        }
        this.calculated = true;
    }

    public boolean isReady() {
        return !Double.isNaN(this.width) && !Double.isNaN(this.height) && !Double.isInfinite(this.xMin) && !Double.isInfinite(this.xMax) && !Double.isInfinite(this.yMin) && !Double.isInfinite(this.yMax);
    }

    public void reset() {
        this.xMin = Double.POSITIVE_INFINITY;
        this.xMax = Double.NEGATIVE_INFINITY;
        this.yMin = Double.POSITIVE_INFINITY;
        this.yMax = Double.NEGATIVE_INFINITY;
        this.calculated = false;
    }

    public void updatePolygon(Polygon polygon) {
        this.updateRect(polygon.bounds);
    }

    public void updatePolygon(DenseMatrix64F polygon) {
        int len = polygon.numRows;
        double[] d = polygon.data;
        for (int r = 0; r < len; ++r) {
            this.updatePoint(d[2 * r], d[2 * r + 1]);
        }
    }

    public void updateRect(Rect bounds) {
        this.updatePoint(bounds.xMax, bounds.yMax);
        this.updatePoint(bounds.xMin, bounds.yMax);
        this.updatePoint(bounds.xMin, bounds.yMin);
        this.updatePoint(bounds.xMax, bounds.yMin);
    }

    public void updateCircle(Circle c) {
        this.updateCircle(c.getX(), c.getY(), c.getRadius());
    }

    public void updateCircle(double x, double y, double radius) {
        this.updatePoint(x, y);
        this.updatePoint(x - radius, y - radius);
        this.updatePoint(x + radius, y - radius);
        this.updatePoint(x - radius, y + radius);
        this.updatePoint(x + radius, y + radius);
    }

    public void margin(double m) {
        double w = this.xMax - this.xMin;
        double h = this.yMax - this.yMin;
        this.setRect(this.xMin - w * m, this.xMax + w * m, this.yMin - w * m, this.yMax + w * m);
    }

    public void updatePoint(double x, double y) {
        if (x < this.xMin) {
            this.xMin = x;
            this.calculated = false;
        }
        if (x > this.xMax) {
            this.xMax = x;
            this.calculated = false;
        }
        if (y < this.yMin) {
            this.yMin = y;
            this.calculated = false;
        }
        if (y > this.yMax) {
            this.yMax = y;
            this.calculated = false;
        }
    }

    public final void setRect(double xMin, double xMax, double yMin, double yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.calculated = false;
    }

    public final void setRect(double x, double y, double r) {
        this.xMin = x - r;
        this.xMax = x + r;
        this.yMin = y - r;
        this.yMax = y + r;
        this.calculated = false;
    }

    public double toScreenX(double x) {
        assert (this.isReady());
        if (!this.calculated) {
            this.calculate();
        }
        return this.scale * x + this.xOff;
    }

    public double toScreenY(double y) {
        assert (this.isReady());
        if (!this.calculated) {
            this.calculate();
        }
        return -this.scale * y + this.yOff;
    }

    public double fromScreenX(double x) {
        assert (this.isReady());
        if (!this.calculated) {
            this.calculate();
        }
        return (x - this.xOff) / this.scale;
    }

    public double fromScreenY(double y) {
        assert (this.isReady());
        if (!this.calculated) {
            this.calculate();
        }
        return -(y - this.yOff) / this.scale;
    }

    public double scaleToScreen(double d) {
        assert (this.isReady());
        if (!this.calculated) {
            this.calculate();
        }
        return d * this.scale;
    }

    public double scaleFromScreen(double d) {
        assert (this.isReady());
        if (!this.calculated) {
            this.calculate();
        }
        return d / this.scale;
    }
}

