/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.nio.channels;

import java.io.Closeable;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import org.vesalainen.util.logging.JavaLogging;

public class UnconnectedDatagramChannel
extends SelectableChannel
implements ByteChannel,
GatheringByteChannel,
ScatteringByteChannel,
AutoCloseable,
Closeable {
    private static final byte[] IPv4BroadcastAddress = new byte[]{-1, -1, -1, -1};
    private final DatagramChannel channel;
    private final InetSocketAddress address;
    private final ByteBuffer readBuffer;
    private final ByteBuffer writeBuffer;
    private final JavaLogging log = new JavaLogging(this.getClass());
    private final boolean loop;
    private List<InetAddress> locals;

    public UnconnectedDatagramChannel(DatagramChannel channel, InetSocketAddress address, int maxDatagramSize, boolean direct, boolean loop) throws SocketException {
        this.channel = channel;
        this.address = address;
        if (direct) {
            this.readBuffer = ByteBuffer.allocateDirect(maxDatagramSize);
            this.writeBuffer = ByteBuffer.allocateDirect(maxDatagramSize);
        } else {
            this.readBuffer = ByteBuffer.allocate(maxDatagramSize);
            this.writeBuffer = ByteBuffer.allocate(maxDatagramSize);
        }
        this.loop = loop;
        if (!loop) {
            this.locals = new ArrayList<InetAddress>();
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                while (ias.hasMoreElements()) {
                    this.locals.add(ias.nextElement());
                }
            }
        }
    }

    public static UnconnectedDatagramChannel open(String host, int port, int maxDatagramSize, boolean direct, boolean loop) throws IOException {
        StandardProtocolFamily family = StandardProtocolFamily.INET;
        InetAddress ia = InetAddress.getByName(host);
        if (ia instanceof Inet6Address) {
            family = StandardProtocolFamily.INET6;
        }
        InetSocketAddress address = new InetSocketAddress(ia, port);
        DatagramChannel channel = DatagramChannel.open(family);
        if (UnconnectedDatagramChannel.isBroadcast(ia)) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_BROADCAST, (Object)true);
        }
        channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        channel.bind(new InetSocketAddress(port));
        if (ia.isMulticastAddress()) {
            channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_LOOP, (Object)loop);
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.supportsMulticast() || !ni.isUp()) continue;
                channel.join(ia, ni);
            }
        }
        return new UnconnectedDatagramChannel(channel, address, maxDatagramSize, direct, loop);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int rem = dst.remaining();
        int p1 = dst.position();
        InetSocketAddress sa = (InetSocketAddress)this.channel.receive(dst);
        if (sa == null) {
            return 0;
        }
        if (!this.loop && this.locals.contains(sa.getAddress())) {
            dst.position(p1);
            this.log.warning("local send %s while IP_MULTICAST_LOOP false", sa);
            return 0;
        }
        int p2 = dst.position();
        this.log(Level.FINEST, "receive", dst, p1, p2 - p1);
        return rem - dst.remaining();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int rem = src.remaining();
        int p1 = src.position();
        this.channel.send(src, this.address);
        int p2 = src.position();
        this.log(Level.FINEST, "send", src, p1, p2 - p1);
        return rem - src.remaining();
    }

    private void log(Level level, String msg, ByteBuffer bb, int offset, int length) {
        if (this.log.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            for (int ii = 0; ii < length; ++ii) {
                char cc = (char)(bb.get(ii + offset) & 0xFF);
                if (cc >= ' ' && cc <= 'z') {
                    sb.append(cc);
                    continue;
                }
                sb.append('<').append(Integer.toHexString(cc)).append('>');
            }
            this.log.log(level, "%s='%s'", msg, sb.toString());
        }
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 1) {
            return this.write(srcs[offset]);
        }
        this.writeBuffer.clear();
        for (int ii = 0; ii < length; ++ii) {
            ByteBuffer bb = srcs[ii + offset];
            this.writeBuffer.put(bb);
        }
        this.writeBuffer.flip();
        return this.write(this.writeBuffer);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (length == 1 || dsts[offset].remaining() > this.readBuffer.capacity()) {
            return this.read(dsts[offset]);
        }
        this.readBuffer.clear();
        int res = this.read(this.readBuffer);
        this.readBuffer.flip();
        for (int ii = 0; ii < length && this.readBuffer.hasRemaining(); ++ii) {
            ByteBuffer bb = dsts[ii + offset];
            if (bb.remaining() >= this.readBuffer.remaining()) {
                bb.put(this.readBuffer);
                continue;
            }
            int lim = this.readBuffer.limit();
            this.readBuffer.limit(this.readBuffer.position() + bb.remaining());
            bb.put(this.readBuffer);
            this.readBuffer.limit(lim);
        }
        return res;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    private static boolean isBroadcast(InetAddress addr) {
        return Arrays.equals(IPv4BroadcastAddress, addr.getAddress());
    }

    @Override
    public SelectorProvider provider() {
        return this.channel.provider();
    }

    @Override
    public int validOps() {
        return this.channel.validOps();
    }

    @Override
    public boolean isRegistered() {
        return this.channel.isRegistered();
    }

    @Override
    public SelectionKey keyFor(Selector sel) {
        return this.channel.keyFor(sel);
    }

    @Override
    public SelectionKey register(Selector sel, int ops, Object att) throws ClosedChannelException {
        return this.channel.register(sel, ops, att);
    }

    @Override
    public SelectableChannel configureBlocking(boolean block) throws IOException {
        return this.channel.configureBlocking(block);
    }

    @Override
    public boolean isBlocking() {
        return this.channel.isBlocking();
    }

    @Override
    public Object blockingLock() {
        return this.channel.blockingLock();
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.channel.close();
    }
}

