/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.nio.channels;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import org.vesalainen.nio.channels.ProtocolHandler;

public class ReadableByteChannelFactory {
    private static final Map<String, ProtocolHandler> map = new HashMap<String, ProtocolHandler>();

    public static void addHandler(String protocol, ProtocolHandler handler) {
        map.put(protocol, handler);
    }

    public static boolean hasHandler(String name) {
        return map.containsKey(name);
    }

    public static ReadableByteChannel getInstance(File file) throws IOException {
        return ReadableByteChannelFactory.getInstance(file.toPath());
    }

    public static ReadableByteChannel getInstance(Path path) throws IOException {
        return FileChannel.open(path, StandardOpenOption.READ);
    }

    public static ReadableByteChannel getInstance(URI uri) throws IOException {
        return ReadableByteChannelFactory.getInstance(uri.toURL());
    }

    public static ReadableByteChannel getInstance(URL url) throws IOException {
        ProtocolHandler ph = map.get(url.getProtocol());
        if (ph != null) {
            return ph.create(url);
        }
        return Channels.newChannel(url.openStream());
    }

    static {
        ReadableByteChannelFactory.addHandler("file", new FileHandler());
        ReadableByteChannelFactory.addHandler("http", new HTTPHandler());
    }

    private static class HTTPHandler
    implements ProtocolHandler {
        private HTTPHandler() {
        }

        @Override
        public ReadableByteChannel create(URL url) throws IOException {
            int port = url.getPort();
            if (port == -1) {
                port = 80;
            }
            InetSocketAddress sa = new InetSocketAddress(url.getHost(), port);
            SocketChannel sc = SocketChannel.open(sa);
            ByteBuffer bb = ByteBuffer.allocate(256);
            this.write(sc, "GET " + url.getFile() + " HTTP/1.1\r\n");
            this.write(sc, "Host: " + url.getHost() + "\r\n");
            this.write(sc, "Connection: close\r\n\r\n");
            String hdr = this.readline(sc);
            if (!hdr.startsWith("HTTP/1.1 200")) {
                throw new IOException(hdr);
            }
            while (hdr.length() > 2) {
                System.err.print(hdr);
                hdr = this.readline(sc);
            }
            sc.shutdownOutput();
            return sc;
        }

        private void write(SocketChannel sc, String line) throws IOException {
            byte[] bytes = line.getBytes(StandardCharsets.US_ASCII);
            ByteBuffer wrap = ByteBuffer.wrap(bytes);
            sc.write(wrap);
        }

        private String readline(SocketChannel sc) throws IOException {
            StringBuilder sb = new StringBuilder();
            ByteBuffer bb = ByteBuffer.allocate(1);
            while (true) {
                int rc;
                if ((rc = sc.read(bb)) != 1) {
                    throw new IOException("unexpected end of channel");
                }
                char cc = (char)bb.get(0);
                sb.append(cc);
                if (cc == '\n') {
                    return sb.toString();
                }
                bb.clear();
            }
        }
    }

    private static class FileHandler
    implements ProtocolHandler {
        private FileHandler() {
        }

        @Override
        public ReadableByteChannel create(URL url) throws IOException {
            File file = new File(url.getFile());
            return ReadableByteChannelFactory.getInstance(file);
        }
    }
}

