/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.nio.channels;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.vesalainen.nio.channels.MultiProviderSelectionKey;
import org.vesalainen.nio.channels.MultiSelectorProvider;
import org.vesalainen.util.concurrent.ConcurrentArraySet;
import org.vesalainen.util.logging.JavaLogging;

public class MultiProviderSelector
extends AbstractSelector {
    private Map<SelectorProvider, Selector> map = new HashMap<SelectorProvider, Selector>();
    private Map<Selector, SelectorWrapper> wrapperMap = new HashMap<Selector, SelectorWrapper>();
    private Map<Selector, Thread> threadMap = new HashMap<Selector, Thread>();
    private Set<SelectionKey> keys = new ConcurrentArraySet<SelectionKey>();
    private final Set<SelectionKey> unmodifiableKeys = Collections.unmodifiableSet(this.keys);
    private Set<SelectionKey> selectedKeys = new ConcurrentArraySet<SelectionKey>();
    private final Map<SelectionKey, MultiProviderSelectionKey> keyMap = new HashMap<SelectionKey, MultiProviderSelectionKey>();
    private Set<SelectionKey> keyPool = new ConcurrentArraySet<SelectionKey>();
    private IOException ioException;
    private final Semaphore semaphore = new Semaphore(0);
    private final Semaphore wrapperSemaphore = new Semaphore(0);
    private final AtomicInteger wrapperPermissions = new AtomicInteger();
    private final ReentrantLock lock = new ReentrantLock();
    private boolean wait;
    private final JavaLogging log = new JavaLogging(this.getClass());

    public MultiProviderSelector() {
        super(MultiSelectorProvider.provider());
    }

    @Override
    public Selector wakeup() {
        this.log.fine("wakeup(%s", this);
        for (SelectorWrapper sw : this.wrapperMap.values()) {
            sw.selector.wakeup();
        }
        return this;
    }

    @Override
    protected void implCloseSelector() throws IOException {
        this.log.fine("close(%s", this);
        for (Selector selector : this.map.values()) {
            Thread thread = this.threadMap.get(selector);
            thread.interrupt();
            selector.close();
        }
        this.map = null;
        this.keys = null;
        this.selectedKeys = null;
        this.keyPool = null;
        this.wrapperMap = null;
        this.threadMap = null;
    }

    @Override
    protected SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        this.log.fine("register(%s)", this);
        this.lock.lock();
        try {
            SelectionKey sk = null;
            SelectorProvider provider = ch.provider();
            Selector selector = this.map.get(provider);
            if (selector == null) {
                selector = provider.openSelector();
                this.map.put(provider, selector);
                SelectorWrapper sw = new SelectorWrapper(selector);
                this.wrapperMap.put(selector, sw);
                Thread thread = new Thread((Runnable)sw, MultiProviderSelector.class.getSimpleName());
                this.threadMap.put(selector, thread);
                sk = ch.register(selector, ops);
                this.wrapperPermissions.incrementAndGet();
                thread.start();
                this.log.info("start selector thread", new Object[0]);
            } else {
                selector.wakeup();
                sk = ch.register(selector, ops);
            }
            MultiProviderSelectionKey mpsk = new MultiProviderSelectionKey(this, sk);
            mpsk.attach(att);
            this.keys.add(mpsk);
            this.keyMap.put(sk, mpsk);
            MultiProviderSelectionKey multiProviderSelectionKey = mpsk;
            return multiProviderSelectionKey;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<SelectionKey> keys() {
        return this.unmodifiableKeys;
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        return this.selectedKeys;
    }

    @Override
    public int selectNow() throws IOException {
        int res = 0;
        for (Selector selector : this.map.values()) {
            res += selector.selectNow();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int select(long timeout) throws IOException {
        int keyCount = 0;
        try {
            this.lock.lock();
            try {
                this.wrapperSemaphore.release(this.wrapperPermissions.getAndSet(0));
                if (this.ioException != null) {
                    throw this.ioException;
                }
                this.handleCancelled();
                if (this.keyPool.isEmpty()) {
                    this.wait = true;
                } else {
                    keyCount = this.provision();
                }
            }
            finally {
                this.lock.unlock();
            }
            if (this.wait) {
                long nanoTime1 = System.nanoTime();
                if (this.semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
                    long nanoTime2 = System.nanoTime();
                    this.log.fine("waited %d nanos", nanoTime2 - nanoTime1);
                    keyCount = this.provision();
                    this.handleCancelled();
                }
                this.wait = false;
            }
            this.log.fine("select() -> %d", keyCount);
            return keyCount;
        }
        catch (InterruptedException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCancelled() {
        this.lock.lock();
        try {
            Set<SelectionKey> cancelledKeys;
            Set<SelectionKey> set = cancelledKeys = this.cancelledKeys();
            synchronized (set) {
                Iterator<SelectionKey> iterator = cancelledKeys.iterator();
                while (iterator.hasNext()) {
                    MultiProviderSelectionKey sk = (MultiProviderSelectionKey)iterator.next();
                    this.deregister(sk);
                    this.keys.remove(sk);
                    this.keyMap.remove(sk.getRealSelectionKey());
                    sk.doCancel();
                    iterator.remove();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int provision() {
        int count = 0;
        this.lock.lock();
        try {
            for (SelectionKey sk : this.keyPool) {
                MultiProviderSelectionKey mpsk = this.keyMap.get(sk);
                if (mpsk != null) {
                    if (this.selectedKeys.contains(mpsk)) continue;
                    this.selectedKeys.add(mpsk);
                    ++count;
                    continue;
                }
                this.log.warning("selectionKey=null", new Object[0]);
            }
            this.keyPool.clear();
            int n = count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int select() throws IOException {
        return this.select(-1L);
    }

    private class SelectorWrapper
    extends JavaLogging
    implements Runnable {
        Selector selector;

        public SelectorWrapper(Selector selector) {
            this.selector = selector;
            this.setLogger(this.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (MultiProviderSelector.this.isOpen()) {
                MultiProviderSelector.this.lock.lock();
                try {
                    if (this.selector.keys().isEmpty()) {
                        this.info("stop selector thread", new Object[0]);
                        MultiProviderSelector.this.map.remove(this.selector.provider());
                        MultiProviderSelector.this.wrapperMap.remove(this.selector);
                        MultiProviderSelector.this.threadMap.remove(this.selector);
                        return;
                    }
                }
                finally {
                    MultiProviderSelector.this.lock.unlock();
                }
                int count = 0;
                IOException ioExc = null;
                try {
                    MultiProviderSelector.this.wrapperSemaphore.acquire();
                    count = this.selector.select();
                    this.fine("select(%s)=%d (%d)", this, count, this.selector.selectedKeys().size());
                }
                catch (IOException ex) {
                    this.log(Level.SEVERE, ex, "IOException(%s)", this.toString());
                    ioExc = ex;
                }
                catch (InterruptedException ex) {
                    this.log(Level.OFF, ex, ex.getMessage(), new Object[0]);
                }
                MultiProviderSelector.this.lock.lock();
                try {
                    if (ioExc == null) {
                        Set<SelectionKey> keys = this.selector.selectedKeys();
                        MultiProviderSelector.this.keyPool.addAll(keys);
                        keys.clear();
                        MultiProviderSelector.this.wrapperPermissions.incrementAndGet();
                        continue;
                    }
                    MultiProviderSelector.this.ioException = ioExc;
                }
                finally {
                    if (MultiProviderSelector.this.wait) {
                        MultiProviderSelector.this.semaphore.release();
                    }
                    MultiProviderSelector.this.lock.unlock();
                }
            }
        }

        public String toString() {
            return "SelectorWrapper{selector=" + this.selector + '}';
        }
    }
}

