/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.nio.channels;

import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectionKey;
import org.vesalainen.nio.channels.MultiProviderSelector;

public class MultiProviderSelectionKey
extends AbstractSelectionKey {
    private final MultiProviderSelector selector;
    private final SelectionKey sk;

    public MultiProviderSelectionKey(MultiProviderSelector selector, SelectionKey sk) {
        this.selector = selector;
        this.sk = sk;
    }

    @Override
    public SelectableChannel channel() {
        return this.sk.channel();
    }

    @Override
    public Selector selector() {
        return this.selector;
    }

    @Override
    public int interestOps() {
        return this.sk.interestOps();
    }

    @Override
    public SelectionKey interestOps(int ops) {
        this.sk.interestOps(ops);
        return this;
    }

    @Override
    public int readyOps() {
        return this.sk.readyOps();
    }

    void doCancel() {
        assert (!this.isValid());
        this.sk.cancel();
        this.sk.selector().wakeup();
    }

    public SelectionKey getRealSelectionKey() {
        return this.sk;
    }
}

