/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.nio.channels;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import org.vesalainen.nio.channels.ByteBufferOutputStream;

public class ChannelHelper {
    public static OutputStream getGatheringOutputStream(ByteBuffer[] srcs, int offset, int length) {
        return new ByteBufferOutputStream(srcs, offset, length);
    }

    public static GatheringByteChannel getGatheringByteChannel(WritableByteChannel channel) {
        return new GatheringByteChannelImpl(channel);
    }

    public static ScatteringByteChannel getScatteringByteChannel(ReadableByteChannel channel) {
        return new ScatteringByteChannelImpl(channel);
    }

    public static class GatheringByteChannelImpl
    implements GatheringByteChannel {
        private WritableByteChannel channel;

        public GatheringByteChannelImpl(WritableByteChannel channel) {
            this.channel = channel;
        }

        @Override
        public synchronized long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            long res = 0L;
            for (int ii = 0; ii < length; ++ii) {
                ByteBuffer bb = srcs[ii + offset];
                if (!bb.hasRemaining()) continue;
                res += (long)this.channel.write(bb);
                if (bb.hasRemaining()) break;
            }
            return res;
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            return this.write(srcs, 0, srcs.length);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.channel.write(src);
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }

    public static class ScatteringByteChannelImpl
    implements ScatteringByteChannel {
        private ReadableByteChannel channel;

        public ScatteringByteChannelImpl(ReadableByteChannel channel) {
            this.channel = channel;
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            long res = 0L;
            for (int ii = 0; ii < length; ++ii) {
                ByteBuffer bb = dsts[ii + offset];
                if (!bb.hasRemaining()) continue;
                int rc = this.channel.read(bb);
                if (rc == -1) {
                    if (res == 0L) {
                        return -1L;
                    }
                    return res;
                }
                res += (long)rc;
                if (bb.hasRemaining()) break;
            }
            return res;
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.channel.read(dst);
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }
}

