/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.nio.channels;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer[] srcs;
    private int offset;
    private int length;

    public ByteBufferOutputStream() {
    }

    public ByteBufferOutputStream(ByteBuffer src) {
        this(new ByteBuffer[]{src});
    }

    public ByteBufferOutputStream(ByteBuffer[] srcs) {
        this(srcs, 0, 1);
    }

    public ByteBufferOutputStream(ByteBuffer[] srcs, int offset, int length) {
        this.set(srcs, offset, length);
    }

    public final int getRemaining() {
        int rem = 0;
        for (int ii = 0; ii < this.length; ++ii) {
            rem += this.srcs[this.offset + ii].remaining();
        }
        return rem;
    }

    public final void set(ByteBuffer src) {
        this.set(new ByteBuffer[]{src});
    }

    public final void set(ByteBuffer[] srcs) {
        this.set(srcs, 0, srcs.length);
    }

    public final void set(ByteBuffer[] srcs, int offset, int length) {
        this.srcs = srcs;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.srcs[this.offset].put((byte)(b & 0xFF));
        }
        catch (BufferOverflowException ex) {
            if (this.length > 1) {
                ++this.offset;
                --this.length;
                this.write(b);
            }
            throw new IOException("buffer overflow");
        }
    }
}

